/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemDynamite;
import betterwithmods.util.FluidUtils;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityDynamite
extends Entity
implements IProjectile {
    private static final float pi = 3.141593f;
    private static final DataParameter<ItemStack> DYNAMITE_TYPE = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDynamite(World world) {
        this(world, 0.0, 0.0, 0.0, 0);
    }

    public EntityDynamite(World world, double xPos, double yPos, double zPos, int fuse) {
        super(world);
        this.func_70105_a(0.25f, 0.4f);
        this.func_70107_b(xPos, yPos, zPos);
        this.setFuse(fuse);
    }

    public EntityDynamite(World world, EntityLivingBase owner, int fuse) {
        this(world);
        this.func_70012_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.75f, 1.0f);
        this.setFuse(fuse);
    }

    public void setDynamiteStack(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        this.field_70180_af.func_187227_b(DYNAMITE_TYPE, (Object)stack);
    }

    public ItemStack getDynamiteStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(DYNAMITE_TYPE);
    }

    public float getFuseSlide() {
        float maxFuse = this.getMaxFuse();
        return (maxFuse - (float)this.getFuse()) / maxFuse;
    }

    public int getMaxFuse() {
        Item item = this.getDynamiteStack().func_77973_b();
        if (item instanceof ItemDynamite) {
            return ((ItemDynamite)item).getFuseTime();
        }
        return 1;
    }

    public int getFuse() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public void setFuse(int fuse) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuse);
    }

    protected void func_70081_e(int amount) {
        super.func_70081_e(amount);
        if (this.getFuse() <= 0) {
            this.setFuse(50);
        }
    }

    public void func_70015_d(int seconds) {
        super.func_70015_d(seconds);
        if (this.getFuse() <= 0) {
            this.setFuse(50);
        }
    }

    public void func_70071_h_() {
        double speed;
        int fuse;
        super.func_70071_h_();
        Fluid fluid = FluidUtils.getFluidFromBlock(this.field_70170_p, this.func_180425_c(), EnumFacing.UP);
        if (fluid != null && fluid.getTemperature() >= FluidRegistry.LAVA.getTemperature()) {
            this.setFuse(1);
        }
        boolean flag1 = this.func_70026_G();
        if (this.field_70170_p.func_147470_e(this.func_174813_aQ().func_186664_h(0.001))) {
            this.func_70081_e(1);
            if (!flag1) {
                this.func_70015_d(8);
            }
        }
        if ((fuse = this.getFuse()) > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)100);
                if (fuse % 20 == 0) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            float smokeOffset = 0.25f;
            if (fluid != null && fluid == FluidRegistry.WATER) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            } else {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            if (--fuse <= 0) {
                if (!this.func_130014_f_().field_72995_K) {
                    this.explode();
                }
                this.func_70106_y();
            } else {
                this.setFuse(fuse);
            }
        } else if (this.field_70122_E && (speed = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.convertToItem();
        }
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onImpact(raytraceresult);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f1 = 0.999f;
        if (this.func_70090_H()) {
            f1 = 0.6f;
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_145775_I();
        if (this.field_70122_E) {
            this.field_70159_w *= 0.7;
            this.field_70179_y *= 0.7;
        }
        this.func_70066_B();
    }

    protected void onImpact(RayTraceResult result) {
        double speed;
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && (speed = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) > 0.1) {
            switch (result.field_178784_b) {
                case DOWN: 
                case UP: {
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                    this.field_70181_x *= -0.5;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.field_70179_y *= -0.7;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.field_70159_w *= -0.7;
                }
            }
        }
    }

    public void func_70186_c(double dX, double dY, double dZ, float angle, float f) {
        float sqrt = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
        dX /= (double)sqrt;
        dY /= (double)sqrt;
        dZ /= (double)sqrt;
        dX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        this.field_70159_w = dX *= (double)angle;
        this.field_70181_x = dY *= (double)angle;
        this.field_70179_y = dZ *= (double)angle;
        float pitch = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dX, dZ) * 180.0 / (double)3.141593f);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dY, pitch) * 180.0 / (double)3.141593f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DYNAMITE_TYPE, (Object)new ItemStack(BWMItems.DYNAMITE));
        this.field_70180_af.func_187214_a(FUSE, (Object)0);
    }

    public void func_70037_a(@Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b("Fuse")) {
            this.setFuse(tag.func_74762_e("Fuse"));
        }
        this.setDynamiteStack(new ItemStack(tag.func_74775_l("Dynamite")));
    }

    public void func_70014_b(@Nonnull NBTTagCompound tag) {
        if (this.getFuse() > 0) {
            tag.func_74768_a("Fuse", this.getFuse());
        }
        tag.func_74782_a("Dynamite", (NBTBase)this.getDynamiteStack().serializeNBT());
    }

    public void explode() {
        Item item = this.getDynamiteStack().func_77973_b();
        if (item instanceof ItemDynamite) {
            ((ItemDynamite)item).explode(this);
        }
    }

    public void redneckFishing(BlockPos center, Iterable<BlockPos> set, float chance) {
        if (!this.isWaterBlock(center)) {
            return;
        }
        for (BlockPos pos : set) {
            if (!this.isWaterBlock(pos) || !(this.field_70146_Z.nextFloat() < chance)) continue;
            this.spawnDeadFish(pos);
        }
    }

    @Deprecated
    private boolean isWaterBlock(BlockPos pos) {
        Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
        return block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    private void spawnDeadFish(BlockPos pos) {
        LootContext.Builder build = new LootContext.Builder((WorldServer)this.field_70170_p);
        List fish = this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186390_ao).func_186462_a(this.field_70170_p.field_73012_v, build.func_186471_a());
        for (ItemStack stack : fish) {
            InvUtils.spawnStack(this.field_70170_p, pos, Lists.newArrayList((Object[])new ItemStack[]{stack}));
        }
    }

    private void convertToItem() {
        if (!this.field_70170_p.field_72995_K) {
            InvUtils.spawnStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20, this.getDynamiteStack());
        }
        this.func_70106_y();
    }
}

