/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.advancements.BWAdvancements;
import betterwithmods.common.blocks.BlockInfernalEnchanter;
import betterwithmods.common.blocks.tile.TileBasic;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityInfernalEnchanter
extends TileBasic
implements ITickable {
    private static final int RADIUS = 8;
    public int bookcaseCount;
    private boolean active;

    private static float getPower(World world, BlockPos pos) {
        float power = ForgeHooks.getEnchantPower((World)world, (BlockPos)pos);
        if (power > 0.0f) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a().func_76220_a()) continue;
                return power;
            }
        }
        return 0.0f;
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_82737_E() % 20L == 0L) {
            this.bookcaseCount = 0;
            for (int x = -8; x <= 8; ++x) {
                for (int y = -8; y <= 8; ++y) {
                    for (int z = -8; z <= 8; ++z) {
                        BlockPos current = this.field_174879_c.func_177982_a(x, y, z);
                        float power = TileEntityInfernalEnchanter.getPower(this.field_145850_b, current);
                        if (!(power > 0.0f)) continue;
                        this.bookcaseCount = (int)((float)this.bookcaseCount + power);
                    }
                }
            }
        }
        if (this.func_145831_w().func_82737_E() % 5L == 0L) {
            boolean players;
            List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0));
            boolean bl = players = !playerList.isEmpty();
            if (this.active != players) {
                this.active = players;
                if (this.active) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.active) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockInfernalEnchanter.ACTIVE, (Comparable)Boolean.valueOf(true)));
                int x = this.field_174879_c.func_177958_n();
                int y = this.field_174879_c.func_177956_o();
                int z = this.field_174879_c.func_177952_p();
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)x + 0.125, (double)y + 0.9, (double)z + 0.125, 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)x + 0.875, (double)y + 0.9, (double)z + 0.125, 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)x + 0.875, (double)y + 0.9, (double)z + 0.875, 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)x + 0.125, (double)y + 0.9, (double)z + 0.875, 0.0, 0.0, 0.0, new int[0]);
                playerList.stream().filter(p -> p instanceof EntityPlayerMP).map(p -> (EntityPlayerMP)p).forEach(player -> BWAdvancements.CONSTRUCT_LIBRARY.trigger((EntityPlayerMP)player, this.getBookcaseCount()));
            } else {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockInfernalEnchanter.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public int getBookcaseCount() {
        return this.bookcaseCount;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("bookcaseCount", this.bookcaseCount);
        compound.func_74757_a("active", this.active);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.bookcaseCount = compound.func_74762_e("bookcaseCount");
        this.active = compound.func_74767_n("active");
        super.func_145839_a(compound);
    }

    public String getName() {
        return "bwm.infernalenchanter";
    }

    public boolean isActive() {
        return this.active;
    }
}

