/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mini;

import betterwithmods.common.blocks.mini.BlockMini;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCorner
extends BlockMini {
    private static final AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5), new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5), new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5), new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5)};

    public BlockCorner(Material mat) {
        super(mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CORNER_ORIENTATION, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockMini.PropertyOrientation getOrientationProperty() {
        return CORNER_ORIENTATION;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int ori = (Integer)this.func_176221_a(state, source, pos).func_177229_b((IProperty)this.getOrientationProperty());
        if (ori > 7 || ori < 1) {
            return bounds[0];
        }
        return bounds[ori];
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockMini.PropertyOrientation facingProperty = this.getOrientationProperty();
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5f;
        float hitYFromCenter = hitY - 0.5f;
        float hitZFromCenter = hitZ - 0.5f;
        switch (facing.func_176740_k()) {
            case Y: {
                int[] nArray;
                int corner = this.getCorner(hitXFromCenter, hitZFromCenter);
                if (corner == -1) break;
                if (hitYFromCenter > 0.0f) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = 2;
                    nArray2[1] = 3;
                    nArray2[2] = 1;
                    nArray = nArray2;
                    nArray2[3] = 0;
                } else {
                    int[] nArray3 = new int[4];
                    nArray3[0] = 6;
                    nArray3[1] = 7;
                    nArray3[2] = 5;
                    nArray = nArray3;
                    nArray3[3] = 4;
                }
                int[] corners = nArray;
                state = state.func_177226_a((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                break;
            }
            case X: {
                int[] nArray;
                int corner = this.getCorner(hitYFromCenter, hitZFromCenter);
                if (corner == -1) break;
                if (hitXFromCenter > 0.0f) {
                    int[] nArray4 = new int[4];
                    nArray4[0] = 4;
                    nArray4[1] = 5;
                    nArray4[2] = 1;
                    nArray = nArray4;
                    nArray4[3] = 0;
                } else {
                    int[] nArray5 = new int[4];
                    nArray5[0] = 6;
                    nArray5[1] = 7;
                    nArray5[2] = 3;
                    nArray = nArray5;
                    nArray5[3] = 2;
                }
                int[] corners = nArray;
                state = state.func_177226_a((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                break;
            }
            case Z: {
                int[] nArray;
                int corner = this.getCorner(hitYFromCenter, hitXFromCenter);
                if (corner == -1) break;
                if (hitZFromCenter > 0.0f) {
                    int[] nArray6 = new int[4];
                    nArray6[0] = 7;
                    nArray6[1] = 5;
                    nArray6[2] = 1;
                    nArray = nArray6;
                    nArray6[3] = 3;
                } else {
                    int[] nArray7 = new int[4];
                    nArray7[0] = 6;
                    nArray7[1] = 4;
                    nArray7[2] = 0;
                    nArray = nArray7;
                    nArray7[3] = 2;
                }
                int[] corners = nArray;
                state = state.func_177226_a((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                break;
            }
            default: {
                state = state.func_177226_a((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.func_176734_d().func_176745_a()));
            }
        }
        return state;
    }

    private int getCorner(float hitXFromCenter, float hitZFromCenter) {
        boolean positiveZ;
        boolean positiveX = hitXFromCenter > 0.0f;
        boolean bl = positiveZ = hitZFromCenter > 0.0f;
        if (positiveX && positiveZ) {
            return 0;
        }
        if (positiveX && !positiveZ) {
            return 1;
        }
        if (!positiveX && !positiveZ) {
            return 2;
        }
        if (!positiveX && positiveZ) {
            return 3;
        }
        return -1;
    }
}

