/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWaterwheel;
import betterwithmods.common.blocks.mechanical.tile.TilePump;
import betterwithmods.util.DirUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPump
extends BlockRotate
implements IBlockActive,
IMultiVariants,
IOverpower {
    public BlockPump() {
        super(Material.field_151575_d);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149675_a(true);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185848_a);
    }

    public static boolean hasWaterToPump(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return TileEntityWaterwheel.isWater(world, pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL)));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=false,facing=north"};
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, entity.func_174811_aO().func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFlatFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL, ACTIVE});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.withTile(worldIn, pos).ifPresent(TilePump::onChanged);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.withTile(world, pos).ifPresent(TilePump::onChanged);
        if (this.isActive(state) && world.func_175623_d(pos.func_177984_a()) && BlockPump.hasWaterToPump(world, pos)) {
            world.func_175656_a(pos.func_177984_a(), BWMBlocks.TEMP_LIQUID_SOURCE.func_176223_P());
        }
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177231_a((IProperty)DirUtils.HORIZONTAL));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePump();
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }

    public Optional<TilePump> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TilePump getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePump) {
            return (TilePump)tile;
        }
        return null;
    }
}

