/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.util.DirUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockAxleGenerator
extends BWMBlock
implements IBlockActive {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockAxleGenerator(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DirUtils.AXIS, (Comparable)EnumFacing.Axis.Z).func_177226_a(EnumTier.TIER, (Comparable)((Object)EnumTier.WOOD)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.AXIS, EnumTier.TIER, ACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        int axis = ((EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS)).ordinal();
        int tier = ((EnumTier)((Object)state.func_177229_b(EnumTier.TIER))).ordinal();
        int active = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
        return axis | tier << 2 | active << 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DirUtils.AXIS, (Comparable)DirUtils.getAxis(meta & 3)).func_177226_a(EnumTier.TIER, (Comparable)((Object)EnumTier.VALUES[meta >> 2 & 1])).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta >> 3 == 1));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public abstract ItemStack func_185473_a(World var1, BlockPos var2, IBlockState var3);

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (state.func_177229_b(EnumTier.TIER) == EnumTier.WOOD) {
            drops.add((Object)new ItemStack(BWMBlocks.WOODEN_AXLE));
        } else {
            drops.add((Object)new ItemStack(BWMBlocks.STEEL_AXLE));
        }
        drops.add((Object)this.func_185473_a((World)world, pos, state));
    }

    public IBlockState getAxisState(EnumFacing.Axis axis) {
        return this.func_176223_P().func_177226_a(DirUtils.AXIS, (Comparable)axis);
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(EnumTier.TIER) == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177229_b(EnumTier.TIER) == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (world.func_180495_p(pos).func_177229_b(EnumTier.TIER) == EnumTier.STEEL) {
            return SoundType.field_185852_e;
        }
        return SoundType.field_185848_a;
    }

    public Material func_149688_o(IBlockState state) {
        if (state.func_177229_b(EnumTier.TIER) == EnumTier.STEEL) {
            return Material.field_151573_f;
        }
        return Material.field_151575_d;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAxis(state) == EnumFacing.Axis.Y;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == this.getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }
}

