/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IOverpower;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileAxle;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAxle
extends BlockRotate
implements IOverpower,
IBlockActive {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
    private EnumTier type;
    private final int minPower;
    private final int maxPower;
    private final int maxSignal;

    public BlockAxle(EnumTier type, int minPower, int maxPower, int maxSignal) {
        super(Material.field_151575_d);
        this.type = type;
        this.minPower = minPower;
        this.maxPower = maxPower;
        this.maxSignal = maxSignal;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DirUtils.AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }

    public EnumTier getType() {
        return this.type;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.AXIS, ACTIVE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(DirUtils.AXIS, (Comparable)facing.func_176740_k());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DirUtils.AXIS, (Comparable)DirUtils.getAxis(meta >> 2)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        int axis = ((EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS)).ordinal() << 2;
        int active = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
        return active | axis;
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177231_a(DirUtils.AXIS));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAxis(state) == EnumFacing.Axis.Y;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == this.getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.withTile(world, pos).ifPresent(System.out::println);
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 1, 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.onChange(world, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.onChange(worldIn, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            this.withTile(world, pos).ifPresent(TileAxle::onChanged);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAxle(this.maxPower, this.minPower, (byte)(this.maxSignal + 1));
    }

    public Optional<TileAxle> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TileAxle getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAxle) {
            return (TileAxle)tile;
        }
        return null;
    }

    public EnumFacing[] getAxisDirections(IBlockState state) {
        if (state.func_177230_c() instanceof BlockAxle) {
            return DirUtils.getAxisDirection((EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS));
        }
        return new EnumFacing[0];
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        world.func_175698_g(pos);
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)this, 1, this.func_180651_a(world.func_180495_p(pos))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isActive(state)) {
            this.emitAxleParticles(world, pos, rand);
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.15f, rand.nextFloat() * 0.1f + 0.5f, false);
            }
        }
    }

    private void emitAxleParticles(World world, BlockPos pos, Random rand) {
        IBlockState state;
        int pow = FMLClientHandler.instance().hasOptifine() ? ((Boolean)(state = this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos)).func_177229_b((IProperty)ACTIVE) != false ? 3 : 0) : this.withTile(world, pos).map(TileAxle::getSignal).orElse((byte)0);
        for (int i = 0; i < pow; ++i) {
            float flX = (float)pos.func_177958_n() + rand.nextFloat();
            float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 0.625f;
            float flZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.field_185852_e;
        }
        return SoundType.field_185848_a;
    }

    public Material func_149688_o(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.field_151573_f;
        }
        return Material.field_151575_d;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}

