/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDetector
extends BlockRotate {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static Set<IDetection> DETECTION_HANDLERS = Sets.newHashSet();

    public BlockDetector() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, DirUtils.convertEntityOrientationToFacing(entity, side));
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        super.onBlockPlacedBy(world, pos, state, placer, stack, face, hitX, hitY, hitZ);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setBlockOn(world, pos, false);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.setBlockOn(world, pos, this.detectBlock(world, pos));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isBlockOn(world, pos) ? 15 : 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVE);
    }

    public void setBlockOn(World world, BlockPos pos, boolean on) {
        if (on != this.isBlockOn((IBlockAccess)world, pos)) {
            IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(on));
            if (on) {
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.7f);
            }
            world.func_175656_a(pos, state);
            for (int i = 0; i < 6; ++i) {
                world.func_190524_a(pos.func_177972_a(EnumFacing.func_82600_a((int)i)), (Block)this, pos);
            }
        }
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public boolean detectBlock(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world.func_180495_p(pos));
        BlockPos offset = pos.func_177972_a(facing);
        for (IDetection detection : DETECTION_HANDLERS) {
            if (!detection.apply(facing, world, pos, offset)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ACTIVE});
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177231_a((IProperty)DirUtils.FACING));
    }

    public static class IngredientDetection
    implements IDetection {
        private BlockIngredient ingredients;
        private Predicate<EnumFacing> direction;

        public IngredientDetection(BlockIngredient ingredients) {
            this(ingredients, facing -> true);
        }

        public IngredientDetection(BlockIngredient ingredients, Predicate<EnumFacing> direction) {
            this.ingredients = ingredients;
            this.direction = direction;
        }

        @Override
        public boolean apply(EnumFacing direction, World world, BlockPos pos, BlockPos offset) {
            if (this.direction.test(direction)) {
                return this.ingredients.apply(world, offset, world.func_180495_p(offset));
            }
            return false;
        }
    }

    public static class EntityDetection
    implements IDetection {
        @Override
        public boolean apply(EnumFacing direction, World world, BlockPos pos, BlockPos offset) {
            int x = offset.func_177958_n();
            int y = offset.func_177956_o();
            int z = offset.func_177952_p();
            AxisAlignedBB collisionBox = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            return world.func_175647_a(Entity.class, collisionBox, Entity::func_70089_S).stream().findAny().isPresent();
        }
    }

    public static interface IDetection {
        public boolean apply(EnumFacing var1, World var2, BlockPos var3, BlockPos var4);
    }
}

