/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBucket
extends BWMBlock
implements IRopeConnector {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    public static final PropertyBool IN_WATER = PropertyBool.func_177716_a((String)"in_water");
    public static final PropertyBool HAS_WATER = PropertyBool.func_177716_a((String)"has_water");

    public BlockBucket() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IN_WATER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HAS_WATER, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IN_WATER, HAS_WATER, CONNECTED});
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return EnumFacing.UP;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBucket();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        if (above.func_177230_c() instanceof BlockRope || worldIn.func_175625_s(pos.func_177984_a()) instanceof TileEntityPulley) {
            return this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean canMovePlatforms(World world, BlockPos pos) {
        return false;
    }

    @Override
    public void onLand(World world, BlockPos pos, IBlockState previousState) {
        TileEntityBucket bucket = (TileEntityBucket)world.func_175625_s(pos);
        if (bucket != null) {
            if (bucket.isWater(previousState)) {
                bucket.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
            }
            bucket.fillFromSurrounding();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

