/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAnchor
extends BWMBlock
implements IRopeConnector {
    public static final PropertyBool LINKED = PropertyBool.func_177716_a((String)"linked");
    private static final float HEIGHT = 0.375f;
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0, 0.0, 0.625, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.375);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(0.625, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.375, 1.0, 1.0);
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{D_AABB, U_AABB, N_AABB, S_AABB, W_AABB, E_AABB};

    public BlockAnchor() {
        super(Material.field_151576_e);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
        return BOXES[facing.func_176745_a()];
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, entity.func_70093_af() ? side.func_176734_d() : side);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        BlockPos down = pos.func_177977_b();
        if (!heldItem.func_190926_b()) {
            Block block;
            if (heldItem.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)heldItem.func_77973_b()).func_179223_d()) == BWMBlocks.ROPE) {
                if (!world.field_72995_K) {
                    if (world.func_180495_p(down).func_177230_c() == BWMBlocks.ROPE) {
                        BlockRope.placeRopeUnder(heldItem, world, down, player);
                    } else if (world.func_180495_p(down).func_177230_c().func_176200_f((IBlockAccess)world, down) || world.func_175623_d(down)) {
                        world.func_175656_a(down, BWMBlocks.ROPE.func_176223_P());
                        world.func_184133_a(null, down, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.func_176223_P(), world, null, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (!world.field_72995_K && this.retractRope(world, pos, player)) {
            world.func_184133_a(null, pos, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.func_176223_P(), world, null, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = this.getFacing(world.func_180495_p(pos));
        return side == facing.func_176734_d();
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    private boolean retractRope(World world, BlockPos pos, EntityPlayer player) {
        for (int i = pos.func_177956_o() - 1; i >= 0; --i) {
            BlockPos pos2 = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (world.func_180495_p(pos2).func_177230_c() != BWMBlocks.ROPE && world.func_180495_p(pos2.func_177984_a()).func_177230_c() == BWMBlocks.ROPE) {
                if (!player.field_71075_bZ.field_75098_d) {
                    this.addRopeToInv(world, pos, player);
                }
                return world.func_175698_g(pos2.func_177984_a());
            }
            if (world.func_180495_p(pos2).func_177230_c() == BWMBlocks.ROPE) continue;
            return false;
        }
        return false;
    }

    private void addRopeToInv(World world, BlockPos pos, EntityPlayer player) {
        ItemStack rope = new ItemStack(BWMBlocks.ROPE);
        if (player.field_71071_by.func_70441_a(rope)) {
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else {
            InvUtils.ejectStackWithOffset(world, pos, rope);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING) != EnumFacing.DOWN;
    }

    private boolean isRope(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == BWMBlocks.ROPE;
    }

    private boolean isAnchor(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING) != facing;
    }

    private boolean isPulley(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == BWMBlocks.SINGLE_MACHINES && world.func_180495_p(pos).func_177229_b(BlockMechMachines.TYPE) == BlockMechMachines.EnumType.PULLEY;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
        boolean isConnected = facing == EnumFacing.UP ? this.isRope(world, pos, EnumFacing.UP) || this.isAnchor(world, pos, EnumFacing.UP) || this.isPulley(world, pos, EnumFacing.UP) : this.isRope(world, pos, EnumFacing.DOWN) || this.isAnchor(world, pos, EnumFacing.DOWN);
        return state.func_177226_a((IProperty)LINKED, (Comparable)Boolean.valueOf(isConnected));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, LINKED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == this.getFacing(state).func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

