/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.recipe.impl;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.StackOutput;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ListOutputs
implements IRecipeOutputs {
    protected List<StackOutput> outputs;

    public ListOutputs(ItemStack ... outputs) {
        this(Lists.newArrayList((Object[])outputs));
    }

    public ListOutputs(List<ItemStack> outputs) {
        this.outputs = outputs.stream().filter(s -> !s.func_190926_b()).map(StackOutput::new).collect(Collectors.toList());
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return InvUtils.asNonnullList(this.outputs.stream().map(StackOutput::getOutput).map(ItemStack::func_77946_l).collect(Collectors.toList()));
    }

    @Override
    public List<IOutput> getDisplayOutputs() {
        return this.cast(this.outputs);
    }

    @Override
    public boolean matches(List<ItemStack> outputs) {
        return InvUtils.matchesExact(this.getOutputs(), outputs);
    }

    @Override
    public boolean matchesFuzzy(List<ItemStack> outputs) {
        return InvUtils.matches(this.getOutputs(), outputs);
    }

    @Override
    public boolean isInvalid() {
        return this.outputs.isEmpty();
    }
}

