/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.util;

import com.google.common.collect.Sets;
import gigaherz.lirelent.guidebook.GuidebookMod;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.elements.LinkContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LinkHelper {
    private static final Set<String> PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public static void click(IBookGraphics nav, LinkContext context) {
        if (context.textTarget != null && context.textAction != null) {
            switch (context.textAction) {
                case "openUrl": {
                    LinkHelper.clickWeb(nav, context.textTarget);
                    break;
                }
                case "copyText": {
                    LinkHelper.clickCopyToClipboard(nav, context.textTarget);
                }
            }
        }
        if (context.target != null) {
            nav.navigateTo(context.target);
        }
    }

    public static void clickCopyToClipboard(IBookGraphics nav, String textTarget) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
            if (result) {
                GuiScreen.func_146275_d((String)textTarget);
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("text.copyToClipboard.success", new Object[0]));
            }
            mc.func_147108_a(parent);
        }, I18n.func_135052_a((String)"text.copyToClipboard.line1", (Object[])new Object[0]), I18n.func_135052_a((String)"text.copyToClipboard.line2", (Object[])new Object[0]), 0){

            public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                parent.func_73863_a(-1, -1, partialTicks);
                super.func_73863_a(mouseX, mouseY, partialTicks);
            }
        });
    }

    public static void clickWeb(IBookGraphics nav, String textTarget) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74359_p) {
            return;
        }
        try {
            URI uri = new URI(textTarget);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(textTarget, "Missing protocol");
            }
            if (!PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(textTarget, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (mc.field_71474_y.field_74358_q) {
                ObfuscationReflectionHelper.setPrivateValue(GuiScreen.class, (Object)parent, (Object)uri, (String)"field_175286_t");
                mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)parent, textTarget, 31102009, false){

                    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                        parent.func_73863_a(-1, -1, partialTicks);
                        super.func_73863_a(mouseX, mouseY, partialTicks);
                    }
                });
            } else {
                LinkHelper.openWebLink(uri);
            }
        }
        catch (URISyntaxException urisyntaxexception) {
            GuidebookMod.logger.error("Can't open url {}", (Object)textTarget, (Object)urisyntaxexception);
        }
    }

    private static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            GuidebookMod.logger.error("Can't open url {}", (Object)url, (Object)throwable1);
        }
    }

    public static interface ILinkable {
        public void setLinkContext(LinkContext var1);
    }
}

