/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualText;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementInline;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementParagraph;
import gigaherz.lirelent.guidebook.guidebook.elements.TextStyle;
import gigaherz.lirelent.guidebook.guidebook.util.Rect;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.NamedNodeMap;

public class ElementText
extends ElementInline {
    public final String text;
    public int color;
    public boolean bold;
    public boolean italics;
    public boolean underline;
    public float scale = 1.0f;
    private ElementParagraph temporaryParagraph = null;

    public ElementText(String text, boolean isFirstElement, boolean isLastElement, TextStyle style) {
        super(isFirstElement, isLastElement);
        this.text = ElementText.compactString(text, isFirstElement, isLastElement);
        this.color = style.color;
        this.bold = style.bold;
        this.italics = style.italics;
        this.underline = style.underline;
        this.scale = style.scale;
    }

    private String getStringWithFormat() {
        String textWithFormat = this.getActualString();
        if (this.bold) {
            textWithFormat = TextFormatting.BOLD + textWithFormat;
        }
        if (this.italics) {
            textWithFormat = TextFormatting.ITALIC + textWithFormat;
        }
        if (this.underline) {
            textWithFormat = TextFormatting.UNDERLINE + textWithFormat;
        }
        return textWithFormat;
    }

    protected String getActualString() {
        return this.text;
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        List<VisualElement> elements = nav.measure(this.getStringWithFormat(), width, firstLineWidth, this.scale, this.position, this.baseline, this.verticalAlignment);
        for (VisualElement text : elements) {
            if (!(text instanceof VisualText)) continue;
            ((VisualText)text).color = this.color;
        }
        return elements;
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        if (this.temporaryParagraph == null) {
            this.temporaryParagraph = new ElementParagraph();
            this.temporaryParagraph.inlines.add(this);
        }
        return this.temporaryParagraph.reflow(paragraph, nav, bounds, page);
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        this.scale = ElementText.getAttribute(attributes, "scale", this.scale);
    }

    @Override
    public String toString(boolean complete) {
        return this.text;
    }

    @Override
    public ElementInline copy() {
        ElementText span = super.copy(new ElementText(this.text, false, false, new TextStyle(this.color, this.bold, this.italics, this.underline, this.scale)));
        span.color = this.color;
        span.bold = this.bold;
        span.italics = this.italics;
        span.underline = this.underline;
        span.scale = this.scale;
        return span;
    }

    public static String compactString(String text, boolean trimLeft, boolean trimRight) {
        if (text == null) {
            return null;
        }
        String temp = text.replaceAll("[\n\r]+", "").replaceAll("[ \t]+", " ");
        if (trimLeft) {
            temp = temp.replaceAll("^[ \t]+", "");
        }
        if (trimRight) {
            temp = temp.replaceAll("[ \t]+$", "");
        }
        return temp;
    }
}

