/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import com.google.common.primitives.Ints;
import gigaherz.lirelent.guidebook.GuidebookMod;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualStack;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementInline;
import gigaherz.lirelent.guidebook.guidebook.util.Rect;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementStack
extends ElementInline {
    public static final String WILDCARD = "*";
    public final NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
    public float scale = 1.0f;

    public ElementStack(boolean isFirstElement, boolean isLastElement) {
        super(isFirstElement, isLastElement);
        this.w = 16;
        this.h = 16;
    }

    private Size getVisualSize() {
        int width = (int)((float)this.w * this.scale);
        int height = (int)((float)this.h * this.scale);
        return new Size(width, height);
    }

    private VisualStack getVisual() {
        return new VisualStack(this.stacks, this.getVisualSize(), this.position, this.baseline, this.verticalAlignment, this.scale, this.z);
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        return Collections.singletonList(this.getVisual());
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        VisualStack element = this.getVisual();
        element.position = this.applyPosition(bounds.position, bounds.position);
        paragraph.add(element);
        if (this.position != 0) {
            return bounds.position.y;
        }
        return bounds.position.y + element.size.height;
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        String oreName;
        NonNullList items;
        String itemName;
        Item item;
        int meta = 0;
        int stackSize = 1;
        NBTTagCompound tag = new NBTTagCompound();
        super.parse(book, attributes);
        this.scale = ElementStack.getAttribute(attributes, "scale", this.scale);
        Node attr = attributes.getNamedItem("meta");
        if (attr != null) {
            meta = attr.getTextContent().equals(WILDCARD) ? -1 : Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("count")) != null) {
            stackSize = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("tag")) != null) {
            try {
                tag = JsonToNBT.func_180713_a((String)attr.getTextContent());
            }
            catch (NBTException e) {
                GuidebookMod.logger.warn("Invalid tag format: " + e.getMessage());
            }
        }
        if ((attr = attributes.getNamedItem("item")) != null && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName = attr.getTextContent()))) != null) {
            if ((meta == Short.MAX_VALUE || meta == -1) && item.func_77614_k()) {
                item.func_150895_a(CreativeTabs.field_78027_g, this.stacks);
                for (int i = 0; i < this.stacks.size(); ++i) {
                    ItemStack subitem = (ItemStack)this.stacks.get(i);
                    subitem = subitem.func_77946_l();
                    subitem.func_190920_e(stackSize);
                    subitem.func_77982_d(tag);
                    this.stacks.set(i, (Object)subitem);
                }
            } else {
                ItemStack stack = new ItemStack(item, stackSize, meta);
                stack.func_77982_d(tag);
                this.stacks.add((Object)stack);
            }
        }
        if ((attr = attributes.getNamedItem("ore")) != null && (items = OreDictionary.getOres((String)(oreName = attr.getTextContent()))).size() != 0) {
            for (ItemStack item2 : items) {
                meta = (item2 = item2.func_77946_l()).func_77960_j();
                if (meta == Short.MAX_VALUE && item2.func_77981_g()) {
                    NonNullList subitems = NonNullList.func_191196_a();
                    item2.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subitems);
                    for (ItemStack subitem : subitems) {
                        subitem = subitem.func_77946_l();
                        subitem.func_190920_e(stackSize);
                        subitem.func_77982_d(tag);
                        this.stacks.add((Object)subitem);
                    }
                    continue;
                }
                item2.func_190920_e(stackSize);
                this.stacks.add((Object)item2);
            }
        }
    }

    @Override
    public String toString(boolean complete) {
        return "<stack .../>";
    }

    @Override
    public ElementInline copy() {
        ElementStack newStack = super.copy(new ElementStack(this.isFirstElement, this.isLastElement));
        newStack.scale = this.scale;
        for (ItemStack stack : this.stacks) {
            newStack.stacks.add((Object)stack.func_77946_l());
        }
        return newStack;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }
}

