/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualPanel;
import gigaherz.lirelent.guidebook.guidebook.elements.Element;
import gigaherz.lirelent.guidebook.guidebook.util.Point;
import gigaherz.lirelent.guidebook.guidebook.util.Rect;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementPanel
extends Element {
    public final List<Element> innerElements;
    public boolean asPercent;
    public Integer space;
    public PanelMode mode = PanelMode.DEFAULT;

    public ElementPanel() {
        this.innerElements = Lists.newArrayList();
    }

    public ElementPanel(List<Element> innerElements) {
        this.innerElements = Lists.newArrayList(innerElements);
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        String t;
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("height");
        if (attr != null) {
            t = attr.getTextContent();
            if (t.endsWith("%")) {
                this.asPercent = true;
                t = t.substring(0, t.length() - 1);
            }
            this.space = Ints.tryParse((String)t);
        }
        if ((attr = attributes.getNamedItem("mode")) != null) {
            t = attr.getTextContent();
            try {
                this.mode = PanelMode.valueOf(t.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.mode = PanelMode.DEFAULT;
            }
        }
    }

    @Override
    public String toString(boolean complete) {
        return "<panel ...>" + this.innerElements.stream().map(Object::toString).collect(Collectors.joining()) + "</panel>";
    }

    @Override
    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean oldValue = this.conditionResult;
        this.conditionResult = this.condition == null || this.condition.test(ctx);
        boolean anyChanged = this.conditionResult != oldValue;
        for (Element element : this.innerElements) {
            anyChanged |= element.reevaluateConditions(ctx);
        }
        return anyChanged;
    }

    @Override
    public int reflow(List<VisualElement> list, IBookGraphics nav, Rect bounds, Rect pageBounds) {
        ArrayList visuals = Lists.newArrayList();
        Point adjustedPosition = this.applyPosition(bounds.position, bounds.position);
        Rect adjustedBounds = new Rect(adjustedPosition, bounds.size);
        int top = adjustedPosition.y;
        if (this.mode == PanelMode.DEFAULT) {
            for (Element element : this.innerElements) {
                if (!element.conditionResult) continue;
                element.reflow(visuals, nav, adjustedBounds, pageBounds);
            }
            top += adjustedBounds.size.height;
        } else {
            for (Element element : this.innerElements) {
                if (!element.conditionResult) continue;
                Point tempPos = new Point(adjustedPosition.x, top);
                Size tempSize = new Size(adjustedBounds.size.width, adjustedBounds.size.height - (top - adjustedPosition.y));
                Rect tempBounds = new Rect(tempPos, tempSize);
                top = element.reflow(visuals, nav, tempBounds, pageBounds);
            }
        }
        if (this.position != 0) {
            top = bounds.position.y;
        } else if (this.space != null) {
            top = adjustedPosition.y + (this.asPercent ? this.space * bounds.size.height / 100 : this.space);
        }
        if (visuals.size() > 0) {
            Size size = new Size(bounds.size.width, top - adjustedPosition.y);
            VisualPanel p = new VisualPanel(size, this.position, this.baseline, this.verticalAlignment);
            p.position = adjustedPosition;
            p.children.addAll(visuals);
            list.add(p);
        }
        return top;
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
        for (Element child : this.innerElements) {
            child.findTextures(textures);
        }
    }

    @Override
    public Element copy() {
        ElementPanel space = super.copy(new ElementPanel());
        space.asPercent = this.asPercent;
        space.space = this.space;
        return space;
    }

    @Override
    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        if (this.innerElements.size() == 0) {
            return null;
        }
        ElementPanel panel = super.copy(new ElementPanel());
        panel.space = this.space;
        panel.asPercent = this.asPercent;
        for (Element element : this.innerElements) {
            Element t = element.applyTemplate(book, sourceElements);
            if (t == null) continue;
            panel.innerElements.add(t);
        }
        if (panel.innerElements.size() == 0) {
            return null;
        }
        return panel;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }

    static enum PanelMode {
        DEFAULT,
        FLOW;

    }
}

