/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.SectionRef;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementInline;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementSpan;
import gigaherz.lirelent.guidebook.guidebook.elements.LinkContext;
import gigaherz.lirelent.guidebook.guidebook.util.LinkHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementLink
extends ElementSpan {
    public LinkContext ctx = new LinkContext();

    public ElementLink(boolean isFirstElement, boolean isLastElement, ElementInline ... addRuns) {
        super(isFirstElement, isLastElement, addRuns);
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        List<VisualElement> texts = super.measure(nav, width, firstLineWidth);
        texts.forEach(e -> {
            if (e instanceof LinkHelper.ILinkable) {
                LinkHelper.ILinkable linkable = (LinkHelper.ILinkable)((Object)e);
                linkable.setLinkContext(this.ctx);
            }
        });
        return texts;
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("ref");
        if (attr != null) {
            String ref = attr.getTextContent();
            this.ctx.target = SectionRef.fromString(ref);
        }
        if ((attr = attributes.getNamedItem("href")) != null) {
            this.ctx.textTarget = attr.getTextContent();
            this.ctx.textAction = "openUrl";
        }
        if ((attr = attributes.getNamedItem("text")) != null) {
            this.ctx.textTarget = attr.getTextContent();
        }
        if ((attr = attributes.getNamedItem("action")) != null) {
            this.ctx.textAction = attr.getTextContent();
        }
    }

    @Override
    public ElementInline copy() {
        ElementLink link = super.copy(new ElementLink(this.isFirstElement, this.isLastElement, new ElementInline[0]));
        for (ElementInline run : this.inlines) {
            link.inlines.add(run.copy());
        }
        link.ctx = this.ctx.copy();
        return link;
    }

    @Override
    public String toString(boolean complete) {
        return String.format("<link %s ...>%s</link>", this.ctx.toString(), this.inlines.stream().map(Object::toString).collect(Collectors.joining()));
    }
}

