/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualImage;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementInline;
import gigaherz.lirelent.guidebook.guidebook.util.Rect;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;

public class ElementImage
extends ElementInline {
    public ResourceLocation textureLocation;
    public ResourceLocation hoverTextureLocation;
    public int tx = 0;
    public int ty = 0;
    public int tw = 0;
    public int th = 0;
    public float scale = 1.0f;

    public ElementImage(boolean isFirstElement, boolean isLastElement) {
        super(isFirstElement, isLastElement);
    }

    private Size getVisualSize() {
        int width = (int)((float)(this.w > 0 ? this.w : this.tw) * this.scale);
        int height = (int)((float)(this.h > 0 ? this.h : this.th) * this.scale);
        return new Size(width, height);
    }

    private VisualImage getVisual() {
        return new VisualImage(this.getVisualSize(), this.position, this.baseline, this.verticalAlignment, this.textureLocation, this.hoverTextureLocation, this.tx, this.ty, this.tw, this.th, this.w > 0 ? this.w : this.tw, this.h > 0 ? this.h : this.th, this.scale);
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        return Collections.singletonList(this.getVisual());
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        VisualImage element = this.getVisual();
        element.position = this.applyPosition(bounds.position, bounds.position);
        paragraph.add(element);
        if (this.position != 0) {
            return bounds.position.y;
        }
        return bounds.position.y + element.size.height;
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        this.tx = ElementImage.getAttribute(attributes, "tx", this.tx);
        this.ty = ElementImage.getAttribute(attributes, "ty", this.ty);
        this.tw = ElementImage.getAttribute(attributes, "tw", this.tw);
        this.th = ElementImage.getAttribute(attributes, "th", this.th);
        this.textureLocation = ElementImage.getAttribute(attributes, "src", this.textureLocation);
        this.hoverTextureLocation = ElementImage.getAttribute(attributes, "hoverSrc", this.textureLocation);
        this.scale = ElementImage.getAttribute(attributes, "scale", this.scale);
    }

    @Override
    public String toString(boolean complete) {
        return String.format("<img src=\"%s\" .../>", this.textureLocation);
    }

    @Override
    public ElementInline copy() {
        ElementImage img = super.copy(new ElementImage(this.isFirstElement, this.isLastElement));
        img.textureLocation = new ResourceLocation(this.textureLocation.toString());
        img.tx = this.tx;
        img.ty = this.ty;
        img.tw = this.tw;
        img.th = this.th;
        img.scale = this.scale;
        return img;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }
}

