/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.elements;

import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.IConditionSource;
import gigaherz.lirelent.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.util.Point;
import gigaherz.lirelent.guidebook.guidebook.util.Rect;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Element {
    public static final int VA_TOP = 0;
    public static final int VA_MIDDLE = 1;
    public static final int VA_BASELINE = 2;
    public static final int VA_BOTTOM = 3;
    public static final int POS_RELATIVE = 0;
    public static final int POS_ABSOLUTE = 1;
    public static final int POS_FIXED = 2;
    public int position = 0;
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    public int z = 0;
    public float baseline = 0.7777778f;
    public int verticalAlignment = 2;
    public Predicate<ConditionContext> condition;
    public boolean conditionResult;

    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean oldValue = this.conditionResult;
        this.conditionResult = this.condition == null || this.condition.test(ctx);
        return this.conditionResult != oldValue;
    }

    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        return Collections.emptyList();
    }

    public abstract int reflow(List<VisualElement> var1, IBookGraphics var2, Rect var3, Rect var4);

    public void findTextures(Set<ResourceLocation> textures) {
    }

    public abstract Element copy();

    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        return this.copy();
    }

    public boolean supportsPageLevel() {
        return false;
    }

    public boolean supportsSpanLevel() {
        return true;
    }

    public Point applyPosition(Point point, Point parent) {
        switch (this.position) {
            case 0: {
                return new Point(point.x + this.x, point.y + this.y);
            }
            case 1: {
                return new Point(parent.x + this.x, parent.y + this.y);
            }
            case 2: {
                return new Point(this.x, this.y);
            }
        }
        return new Point(point.x, point.y);
    }

    protected <T extends Element> T copy(T other) {
        other.position = this.position;
        other.x = this.x;
        other.y = this.y;
        other.z = this.z;
        other.w = this.w;
        other.h = this.h;
        return other;
    }

    public void parse(IConditionSource book, NamedNodeMap attributes) {
        String a;
        this.x = Element.getAttribute(attributes, "x", this.x);
        this.y = Element.getAttribute(attributes, "y", this.y);
        this.z = Element.getAttribute(attributes, "z", this.z);
        this.w = Element.getAttribute(attributes, "w", this.w);
        this.h = Element.getAttribute(attributes, "h", this.h);
        this.baseline = Element.getAttribute(attributes, "baseline", this.baseline);
        Node attr = attributes.getNamedItem("align");
        if (attr != null) {
            switch (a = attr.getTextContent()) {
                case "relative": {
                    this.position = 0;
                    break;
                }
                case "absolute": {
                    this.position = 1;
                    break;
                }
                case "fixed": {
                    this.position = 2;
                }
            }
        }
        if ((attr = attributes.getNamedItem("vertical-align")) != null) {
            switch (a = attr.getTextContent()) {
                case "top": {
                    this.verticalAlignment = 0;
                    break;
                }
                case "middle": {
                    this.verticalAlignment = 1;
                    break;
                }
                case "baseline": {
                    this.verticalAlignment = 2;
                    break;
                }
                case "bottom": {
                    this.verticalAlignment = 3;
                }
            }
        }
        if ((attr = attributes.getNamedItem("condition")) != null) {
            this.condition = book.getCondition(attr.getTextContent());
        }
    }

    public void parseChildNodes(IConditionSource book, Node element) {
    }

    protected static String getAttribute(NamedNodeMap attributes, String name, String def) {
        String text;
        Node attr = attributes.getNamedItem(name);
        if (attr != null && (text = attr.getTextContent()) != null) {
            return text;
        }
        return def;
    }

    protected static ResourceLocation getAttribute(NamedNodeMap attributes, String name, ResourceLocation def) {
        String text;
        Node attr = attributes.getNamedItem(name);
        if (attr != null && (text = attr.getTextContent()) != null) {
            return new ResourceLocation(text);
        }
        return def;
    }

    protected static boolean getAttribute(NamedNodeMap attributes, String name, boolean def) {
        Node attr = attributes.getNamedItem(name);
        if (attr != null) {
            String text = attr.getTextContent();
            if ("".equals(text) || "true".equals(text)) {
                return true;
            }
            if ("false".equals(text)) {
                return false;
            }
        }
        return def;
    }

    protected static int getAttribute(NamedNodeMap attributes, String name, int def) {
        Node attr = attributes.getNamedItem(name);
        if (attr != null) {
            String text = attr.getTextContent();
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    protected static float getAttribute(NamedNodeMap attributes, String name, float def) {
        Node attr = attributes.getNamedItem(name);
        if (attr != null) {
            String text = attr.getTextContent();
            try {
                return Float.parseFloat(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    protected static int getColorAttribute(NamedNodeMap attributes, String name, int def) {
        Node attr = attributes.getNamedItem("color");
        if (attr != null) {
            String c = attr.getTextContent();
            if (c.startsWith("#")) {
                c = c.substring(1);
            }
            try {
                if (c.length() <= 6) {
                    return 0xFF000000 | Integer.parseInt(c, 16);
                }
                return Integer.parseInt(c, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public String toString() {
        return this.toString(false);
    }

    public abstract String toString(boolean var1);
}

