/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.drawing;

import gigaherz.lirelent.guidebook.guidebook.HoverContext;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.elements.LinkContext;
import gigaherz.lirelent.guidebook.guidebook.util.LinkHelper;
import gigaherz.lirelent.guidebook.guidebook.util.Size;

public class VisualText
extends VisualElement
implements LinkHelper.ILinkable {
    public String text;
    public int color;
    public float scale;
    public LinkContext linkContext = null;

    public VisualText(String text, Size size, int positionMode, float baseline, int verticalAlign, float scale) {
        super(size, positionMode, baseline, verticalAlign);
        this.text = text;
        this.scale = scale;
    }

    @Override
    public void draw(IBookGraphics nav) {
        super.draw(nav);
        if (this.linkContext != null) {
            nav.addString(this.position.x, this.position.y, this.text, this.linkContext.isHovering ? this.linkContext.colorHover : this.color, this.scale);
        } else {
            nav.addString(this.position.x, this.position.y, this.text, this.color, this.scale);
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean wantsHover() {
        return this.linkContext != null;
    }

    @Override
    public void mouseOver(IBookGraphics nav, HoverContext hoverContext) {
        this.linkContext.isHovering = true;
    }

    @Override
    public void mouseOut(IBookGraphics nav, HoverContext hoverContext) {
        this.linkContext.isHovering = false;
    }

    @Override
    public void click(IBookGraphics nav) {
        if (this.linkContext != null) {
            LinkHelper.click(nav, this.linkContext);
        }
    }

    @Override
    public void setLinkContext(LinkContext ctx) {
        this.linkContext = ctx;
    }
}

