/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.drawing;

import com.google.common.collect.Lists;
import gigaherz.lirelent.guidebook.guidebook.HoverContext;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import java.util.List;

public class VisualPanel
extends VisualElement {
    public final List<VisualElement> children = Lists.newArrayList();
    private VisualElement lastMouseOver = null;

    public VisualPanel(Size size, int positionMode, float baseline, int verticalAlign) {
        super(size, positionMode, baseline, verticalAlign);
    }

    @Override
    public void draw(IBookGraphics nav) {
        super.draw(nav);
        this.children.forEach(e -> e.draw(nav));
    }

    @Override
    public void mouseOver(IBookGraphics nav, HoverContext hoverContext) {
        double x = hoverContext.mouseScaledX;
        double y = hoverContext.mouseScaledY;
        VisualElement newOver = null;
        for (VisualElement child : this.children) {
            if (!child.wantsHover() || !(x >= (double)child.position.x) || !(y >= (double)child.position.y) || !(x - (double)child.position.x < (double)child.size.width) || !(y - (double)child.position.y < (double)child.size.height)) continue;
            newOver = child;
            break;
        }
        if (this.lastMouseOver != null && this.lastMouseOver != newOver) {
            this.lastMouseOver.mouseOut(nav, hoverContext);
        }
        if (newOver != null) {
            newOver.mouseOver(nav, hoverContext);
        }
        this.lastMouseOver = newOver;
    }

    @Override
    public void mouseOut(IBookGraphics nav, HoverContext hoverContext) {
        if (this.lastMouseOver != null) {
            this.lastMouseOver.mouseOut(nav, hoverContext);
            this.lastMouseOver = null;
        }
    }

    @Override
    public void click(IBookGraphics nav) {
        super.click(nav);
        this.children.forEach(e -> e.click(nav));
    }

    @Override
    public boolean wantsHover() {
        return this.children.stream().anyMatch(e -> e.wantsHover());
    }
}

