/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.drawing;

import gigaherz.lirelent.guidebook.guidebook.HoverContext;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.elements.LinkContext;
import gigaherz.lirelent.guidebook.guidebook.util.LinkHelper;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import net.minecraft.util.ResourceLocation;

public class VisualImage
extends VisualElement
implements LinkHelper.ILinkable {
    public final ResourceLocation textureLocation;
    public final ResourceLocation hoverTextureLocation;
    public final int tx;
    public final int ty;
    public final int tw;
    public final int th;
    public final int w;
    public final int h;
    public final float scale;
    public LinkContext linkContext = null;
    private boolean isHovering;

    public VisualImage(Size size, int positionMode, float baseline, int verticalAlign, ResourceLocation textureLocation, ResourceLocation hoverTextureLocation, int tx, int ty, int tw, int th, int w, int h, float scale) {
        super(size, positionMode, baseline, verticalAlign);
        this.textureLocation = textureLocation;
        this.hoverTextureLocation = hoverTextureLocation;
        this.tx = tx;
        this.ty = ty;
        this.tw = tw;
        this.th = th;
        this.w = w;
        this.h = h;
        this.scale = scale;
        this.isHovering = false;
    }

    @Override
    public void draw(IBookGraphics nav) {
        super.draw(nav);
        if (this.hoverTextureLocation != null && this.isHovering) {
            nav.drawImage(this.hoverTextureLocation, this.position.x, this.position.y, this.tx, this.ty, this.w, this.h, this.tw, this.th, this.scale);
        } else {
            nav.drawImage(this.textureLocation, this.position.x, this.position.y, this.tx, this.ty, this.w, this.h, this.tw, this.th, this.scale);
        }
    }

    @Override
    public boolean wantsHover() {
        return this.linkContext != null || this.hoverTextureLocation != null;
    }

    @Override
    public void mouseOver(IBookGraphics nav, HoverContext hoverContext) {
        if (this.linkContext != null) {
            this.linkContext.isHovering = true;
        }
        this.isHovering = true;
    }

    @Override
    public void mouseOut(IBookGraphics nav, HoverContext hoverContext) {
        if (this.linkContext != null) {
            this.linkContext.isHovering = false;
        }
        this.isHovering = false;
    }

    @Override
    public void click(IBookGraphics nav) {
        if (this.linkContext != null) {
            LinkHelper.click(nav, this.linkContext);
        }
    }

    @Override
    public void setLinkContext(LinkContext ctx) {
        this.linkContext = ctx;
    }
}

