/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.conditions;

import com.google.common.base.Strings;
import gigaherz.lirelent.guidebook.guidebook.BookParsingException;
import gigaherz.lirelent.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.lirelent.guidebook.guidebook.conditions.ConditionManager;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.w3c.dom.Node;

public abstract class AdvancementCondition
implements Predicate<ConditionContext> {
    public final ResourceLocation advancement;
    private static Field f_advancementToProgress = ObfuscationReflectionHelper.findField(ClientAdvancementManager.class, (String)"field_192803_d");

    @Nullable
    static AdvancementProgress getAdvancementProgress(ResourceLocation advancement) {
        ClientAdvancementManager mgr = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f();
        Advancement adv = mgr.func_194229_a().func_192084_a(advancement);
        try {
            Map advancementToProgress = (Map)f_advancementToProgress.get(mgr);
            return (AdvancementProgress)advancementToProgress.get(adv);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    protected AdvancementCondition(ResourceLocation advancement) {
        this.advancement = advancement;
    }

    public static void register() {
        ConditionManager.register("advancement-locked", (doc, node) -> new Locked(AdvancementCondition.parseAdvancementLocation(node)));
        ConditionManager.register("advancement-unlocked", (doc, node) -> new Unlocked(AdvancementCondition.parseAdvancementLocation(node)));
    }

    private static ResourceLocation parseAdvancementLocation(Node xmlNode) {
        Node attr = xmlNode.getAttributes().getNamedItem("advancement");
        if (attr == null) {
            throw new BookParsingException("Missing required XML attribute 'advancement'.");
        }
        String stageName = attr.getTextContent();
        if (Strings.isNullOrEmpty((String)stageName)) {
            throw new BookParsingException("Missing required XML attribute 'advancement'.");
        }
        return new ResourceLocation(stageName);
    }

    public static class Unlocked
    extends AdvancementCondition {
        public Unlocked(ResourceLocation stageName) {
            super(stageName);
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            AdvancementProgress p = Unlocked.getAdvancementProgress(this.advancement);
            return p != null && p.func_192105_a();
        }
    }

    public static class Locked
    extends AdvancementCondition {
        public Locked(ResourceLocation stageName) {
            super(stageName);
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            AdvancementProgress p = Locked.getAdvancementProgress(this.advancement);
            return p == null || !p.func_192105_a();
        }
    }
}

