/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.client.background;

import gigaherz.lirelent.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.lirelent.guidebook.guidebook.client.background.IBookBackground;
import gigaherz.lirelent.guidebook.guidebook.client.background.IBookBackgroundFactory;
import gigaherz.lirelent.guidebook.guidebook.elements.ElementImage;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class StaticImage2PageBackground
implements IBookBackground {
    private final GuiGuidebook gui;
    private final ResourceLocation imageLocation;
    private final int imageX;
    private final int imageY;
    private final int imageWidth;
    private final int imageHeight;
    private final int imageFileWidth;
    private final int imageFileHeight;
    private final float scale;
    private boolean closing = false;
    public static IBookBackgroundFactory twoSide2dBackgroundFactory = (gui, backgroundLocation) -> {
        ElementImage elementImage = new ElementImage(false, false);
        elementImage.textureLocation = backgroundLocation;
        elementImage.tx = 0;
        elementImage.ty = 0;
        elementImage.tw = 209;
        elementImage.th = 127;
        elementImage.w = 256;
        elementImage.h = 128;
        elementImage.scale = 1.0f;
        return new StaticImage2PageBackground(gui, elementImage);
    };

    public StaticImage2PageBackground(GuiGuidebook gui, ElementImage image) {
        this.gui = gui;
        this.imageLocation = image.textureLocation;
        this.imageX = image.tx;
        this.imageY = image.ty;
        this.imageWidth = image.tw;
        this.imageHeight = image.th;
        this.imageFileWidth = image.w > 0 ? image.w : image.tw;
        this.imageFileHeight = image.h > 0 ? image.h : image.th;
        this.scale = image.scale;
    }

    @Override
    public IBookBackground.Layout getLayout() {
        return IBookBackground.Layout.TWO_PAGES;
    }

    @Override
    public void draw(float partialTicks, int bookHeight, float scalingFactor) {
        if (this.closing) {
            return;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179137_b((double)((double)this.gui.field_146294_l * 0.5), (double)((double)this.gui.field_146295_m * 0.5), (double)-50.0);
        float effectiveScale = 1.05f * scalingFactor;
        GlStateManager.func_179152_a((float)effectiveScale, (float)effectiveScale, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.field_146297_k.func_110434_K().func_110577_a(this.imageLocation);
        Gui.func_146110_a((int)(-this.imageWidth / 2), (int)(-this.imageHeight / 2), (float)this.imageX, (float)this.imageY, (int)this.imageWidth, (int)this.imageHeight, (float)this.imageFileWidth, (float)this.imageFileHeight);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
    }

    @Override
    public void startClosing() {
        this.closing = true;
    }

    @Override
    public boolean isFullyOpen() {
        return true;
    }

    @Override
    public boolean update() {
        if (this.closing) {
            this.closing = false;
            return true;
        }
        return false;
    }

    @Override
    public int getWidth() {
        return (int)((float)this.imageWidth * this.scale);
    }

    @Override
    public int getHeight() {
        return (int)((float)this.imageHeight * this.scale);
    }

    @Override
    public int getInnerMargin() {
        return 8;
    }

    @Override
    public int getOuterMargin() {
        return 5;
    }

    @Override
    public int getTopMargin() {
        return 5;
    }

    @Override
    public int getBottomMargin() {
        return 8;
    }

    @Override
    public int getBookScaleMargin() {
        return 10;
    }
}

