/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.client;

import gigaherz.lirelent.guidebook.GuidebookMod;
import gigaherz.lirelent.guidebook.guidebook.BookDocument;
import gigaherz.lirelent.guidebook.guidebook.client.BookRegistry;
import gigaherz.lirelent.guidebook.guidebook.client.BookRendering;
import gigaherz.lirelent.guidebook.guidebook.client.background.IBookBackground;
import gigaherz.lirelent.guidebook.guidebook.conditions.ConditionContext;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiGuidebook
extends GuiScreen {
    private static final ResourceLocation BOOK_GUI_TEXTURES = GuidebookMod.location("textures/gui/book.png");
    public final ResourceLocation bookLocation;
    private GuiButton buttonClose;
    private GuiButton buttonNextPage;
    private GuiButton buttonPreviousPage;
    private GuiButton buttonNextChapter;
    private GuiButton buttonPreviousChapter;
    private GuiButton buttonBack;
    private GuiButton buttonHome;
    private ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
    private TextureManager renderEngine;
    private BookRendering book;
    private IBookBackground background;
    public static boolean useNaturalArrows = false;
    private boolean initialized;

    public GuiGuidebook(ResourceLocation book) {
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.initialized = false;
        this.bookLocation = book;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        if (!this.initialized) {
            this.initialized = true;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ConditionContext conditionContext = new ConditionContext();
            conditionContext.setPlayer(player);
            BookDocument theBook = BookRegistry.get(this.bookLocation);
            this.book = (BookRendering)theBook.getRendering();
            boolean conditions = theBook.reevaluateConditions(conditionContext);
            if (this.book == null) {
                this.book = new BookRendering(theBook, this);
                theBook.setRendering(this.book);
            } else {
                this.book.setGui(this);
                if (conditions || this.book.refreshScalingFactor()) {
                    this.book.resetRendering(conditions);
                }
            }
            this.background = this.book.getBookBackground();
            int btnId = 0;
            int left = (this.field_146294_l - this.background.getWidth()) / 2;
            int right = left + this.background.getWidth();
            int top = (this.field_146295_m - this.background.getHeight()) / 2 - 9;
            int bottom = top + this.background.getHeight();
            this.buttonHome = new SpriteButton(btnId++, left - 10, top - 8, 6);
            this.buttonBack = new SpriteButton(btnId++, left + 8, top - 5, 2);
            this.buttonClose = new SpriteButton(btnId++, right - 6, top - 6, 3);
            if (useNaturalArrows) {
                this.buttonPreviousPage = new SpriteButton(btnId++, left + 24, bottom - 13, 1);
                this.buttonNextPage = new SpriteButton(btnId++, right - 42, bottom - 13, 0);
                this.buttonPreviousChapter = new SpriteButton(btnId++, left + 2, bottom - 13, 5);
                this.buttonNextChapter = new SpriteButton(btnId++, right - 23, bottom - 13, 4);
            } else {
                this.buttonPreviousPage = new SpriteButton(btnId++, left + 24, bottom - 13, 0);
                this.buttonNextPage = new SpriteButton(btnId++, right - 42, bottom - 13, 1);
                this.buttonPreviousChapter = new SpriteButton(btnId++, left + 2, bottom - 13, 4);
                this.buttonNextChapter = new SpriteButton(btnId++, right - 23, bottom - 13, 5);
            }
            GuidebookMod.logger.info("Showing gui with " + btnId + " buttons.");
        }
        this.field_146292_n.add(this.buttonHome);
        this.field_146292_n.add(this.buttonBack);
        this.field_146292_n.add(this.buttonClose);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.field_146292_n.add(this.buttonNextPage);
        this.field_146292_n.add(this.buttonPreviousChapter);
        this.field_146292_n.add(this.buttonNextChapter);
        this.updateButtonStates();
        this.repositionButtons();
    }

    private void setupConditionsAndPosition() {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        this.func_183500_a(i, j);
        if (this.book.refreshScalingFactor()) {
            this.book.resetRendering(false);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.buttonClose.field_146127_k) {
                this.background.startClosing();
            } else if (button.field_146127_k == this.buttonHome.field_146127_k) {
                this.book.navigateHome();
            } else if (button.field_146127_k == this.buttonBack.field_146127_k) {
                this.book.navigateBack();
            } else if (button.field_146127_k == this.buttonNextPage.field_146127_k) {
                this.book.nextPage();
            } else if (button.field_146127_k == this.buttonPreviousPage.field_146127_k) {
                this.book.prevPage();
            } else if (button.field_146127_k == this.buttonNextChapter.field_146127_k) {
                this.book.nextChapter();
            } else if (button.field_146127_k == this.buttonPreviousChapter.field_146127_k) {
                this.book.prevChapter();
            }
            this.updateButtonStates();
        }
    }

    private void updateButtonStates() {
        this.buttonClose.field_146124_l = this.background.isFullyOpen();
        this.buttonHome.field_146124_l = this.background.isFullyOpen() && this.book.getBook().home != null;
        this.buttonBack.field_146124_l = this.background.isFullyOpen() && this.book.canGoBack();
        this.buttonNextPage.field_146124_l = this.background.isFullyOpen() && this.book.canGoNextPage();
        this.buttonPreviousPage.field_146124_l = this.background.isFullyOpen() && this.book.canGoPrevPage();
        this.buttonNextChapter.field_146124_l = this.background.isFullyOpen() && this.book.canGoNextChapter();
        this.buttonPreviousChapter.field_146124_l = this.background.isFullyOpen() && this.book.canGoPrevChapter();
        this.buttonClose.field_146125_m = this.buttonClose.field_146124_l;
        this.buttonHome.field_146125_m = this.buttonHome.field_146124_l;
        this.buttonBack.field_146125_m = this.buttonBack.field_146124_l;
        this.buttonNextPage.field_146125_m = this.buttonNextPage.field_146124_l;
        this.buttonPreviousPage.field_146125_m = this.buttonPreviousPage.field_146124_l;
        this.buttonNextChapter.field_146125_m = this.buttonNextChapter.field_146124_l;
        this.buttonPreviousChapter.field_146125_m = this.buttonPreviousChapter.field_146124_l;
    }

    public void func_73876_c() {
        if (this.background.update()) {
            this.field_146297_k.func_147108_a(null);
        }
        this.updateButtonStates();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.background.startClosing();
            return;
        }
        if (keyCode == 14) {
            this.book.navigateBack();
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void repositionButtons() {
        this.setupConditionsAndPosition();
        double bookScale = this.book.getScalingFactor() / (double)this.book.getBook().getFontSize();
        double bookWidth = (double)this.background.getWidth() * bookScale;
        double bookHeight = (double)this.background.getHeight() * bookScale;
        int left = (int)(((double)this.field_146294_l - bookWidth) / 2.0);
        int right = (int)((double)left + bookWidth);
        int top = (int)(((double)this.field_146295_m - bookHeight) / 2.0);
        int bottom = (int)((double)top + bookHeight);
        int leftLeft = left;
        int rightRight = right;
        int topTop = top - 16 + (int)(8.0 * bookScale);
        int bottomBottom = bottom + 2;
        this.buttonHome.field_146128_h = leftLeft;
        this.buttonHome.field_146129_i = topTop;
        this.buttonBack.field_146128_h = leftLeft + 18;
        this.buttonBack.field_146129_i = topTop + 3;
        this.buttonClose.field_146128_h = rightRight - 12;
        this.buttonClose.field_146129_i = topTop;
        this.buttonPreviousPage.field_146128_h = leftLeft + 22;
        this.buttonPreviousPage.field_146129_i = bottomBottom;
        this.buttonPreviousChapter.field_146128_h = leftLeft;
        this.buttonPreviousChapter.field_146129_i = bottomBottom;
        this.buttonNextPage.field_146128_h = rightRight - 16 - 18;
        this.buttonNextPage.field_146129_i = bottomBottom;
        this.buttonNextChapter.field_146128_h = rightRight - 16;
        this.buttonNextChapter.field_146129_i = bottomBottom;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        double backgroundScale = this.book.getScalingFactor() / (double)this.book.getBook().getFontSize();
        double bookHeight = (double)this.background.getHeight() * backgroundScale;
        this.background.draw(partialTicks, (int)bookHeight, (float)backgroundScale);
        if (this.background.isFullyOpen()) {
            this.book.drawCurrentPages();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.background.isFullyOpen()) {
            this.book.mouseHover(mouseX, mouseY);
        }
    }

    public void drawTooltip(ItemStack stack, int x, int y) {
        this.func_146285_a(stack, x, y);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.book.mouseClicked(mouseButton)) {
            return;
        }
        if (mouseButton == 3) {
            this.book.navigateBack();
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ItemModelMesher getMesher() {
        return this.mesher;
    }

    public TextureManager getRenderEngine() {
        return this.renderEngine;
    }

    @SideOnly(value=Side.CLIENT)
    static class SpriteButton
    extends GuiButton {
        private final int whichIcon;
        private static final int[] xPixel = new int[]{5, 5, 4, 4, 4, 4, 4, 29};
        private static final int[] yPixel = new int[]{2, 16, 30, 64, 79, 93, 107, 107};
        private static final int[] xSize = new int[]{17, 17, 18, 13, 21, 21, 15, 15};
        private static final int[] ySize = new int[]{11, 11, 11, 13, 11, 11, 15, 15};

        public SpriteButton(int buttonId, int x, int y, int iconIndex) {
            super(buttonId, x, y, xSize[iconIndex], ySize[iconIndex], "");
            this.whichIcon = iconIndex;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float p_191745_4_) {
            if (this.field_146125_m) {
                boolean hover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
                int x = xPixel[this.whichIcon];
                int y = yPixel[this.whichIcon];
                int w = xSize[this.whichIcon];
                int h = ySize[this.whichIcon];
                if (hover) {
                    x += 25;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, x, y, w, h);
            }
        }
    }
}

