/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.lirelent.guidebook.guidebook.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gigaherz.lirelent.guidebook.ConfigValues;
import gigaherz.lirelent.guidebook.guidebook.BookDocument;
import gigaherz.lirelent.guidebook.guidebook.HoverContext;
import gigaherz.lirelent.guidebook.guidebook.IBookGraphics;
import gigaherz.lirelent.guidebook.guidebook.SectionRef;
import gigaherz.lirelent.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.lirelent.guidebook.guidebook.client.background.AnimatedBookBackground;
import gigaherz.lirelent.guidebook.guidebook.client.background.IBookBackground;
import gigaherz.lirelent.guidebook.guidebook.client.background.IBookBackgroundFactory;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualChapter;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualElement;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualPage;
import gigaherz.lirelent.guidebook.guidebook.drawing.VisualText;
import gigaherz.lirelent.guidebook.guidebook.util.PointD;
import gigaherz.lirelent.guidebook.guidebook.util.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class BookRendering
implements IBookGraphics {
    private final Minecraft mc = Minecraft.func_71410_x();
    private GuiGuidebook gui;
    private BookDocument book;
    private IBookBackground bookBackground;
    private boolean hasScale;
    private double scalingFactor;
    private double scaledWidthD;
    private double scaledHeightD;
    private double scaledWidth;
    private double scaledHeight;
    private int bookWidth;
    private int bookHeight;
    private int innerMargin;
    private int outerMargin;
    private int topMargin;
    private int bottomMargin;
    private int pageWidth;
    private int pageHeight;
    private final List<VisualChapter> chapters = Lists.newArrayList();
    private int lastProcessedChapter = 0;
    private final Stack<PageRef> history = new Stack();
    private int currentChapter = 0;
    private int currentPage = 0;
    private boolean currentPageOnLeftSide = false;
    private VisualElement previousHovering = null;
    public static boolean DEBUG_DRAW_BOUNDS = false;
    public static final Map<ResourceLocation, IBookBackgroundFactory> BACKGROUND_FACTORY_MAP = Maps.newHashMap();
    public static final IBookBackgroundFactory DEFAULT_BACKGROUND = AnimatedBookBackground::new;

    BookRendering(BookDocument book, GuiGuidebook gui) {
        this.book = book;
        this.gui = gui;
        this.bookBackground = this.getBookBackground();
    }

    IBookBackground getBookBackground() {
        this.bookBackground = this.createBackground(this.gui);
        this.refreshScalingFactor();
        return this.bookBackground;
    }

    @Override
    public void resetRendering(boolean contentsChanged) {
        this.chapters.clear();
        this.lastProcessedChapter = 0;
        this.previousHovering = null;
        if (contentsChanged) {
            this.history.clear();
            this.currentChapter = 0;
            this.currentPage = 0;
        }
    }

    @Override
    public Object owner() {
        return this.gui;
    }

    @Override
    public BookDocument getBook() {
        return this.book;
    }

    public void computeBookScale(double scaleFactorCoef) {
        int i;
        int width = this.mc.field_71443_c;
        int height = this.mc.field_71440_d;
        double w = (double)(this.bookBackground.getWidth() + 2 * this.bookBackground.getBookScaleMargin()) / scaleFactorCoef;
        double h = (double)(this.bookBackground.getHeight() + 2 * this.bookBackground.getBookScaleMargin()) / scaleFactorCoef;
        int scaleFactor = 1;
        boolean flag = this.mc.func_152349_b();
        int n = i = ConfigValues.bookGUIScale < 0 ? this.mc.field_71474_y.field_74335_Z : ConfigValues.bookGUIScale;
        if (i == 0) {
            i = 1000;
        }
        while (scaleFactor < i && (double)(width / (scaleFactor + 1)) >= w && (double)(height / (scaleFactor + 1)) >= h) {
            ++scaleFactor;
        }
        if (flag && scaleFactor % 2 != 0 && scaleFactor > 1) {
            --scaleFactor;
        }
        this.scaledWidthD = (double)width / (double)scaleFactor;
        this.scaledHeightD = (double)height / (double)scaleFactor;
        this.scaledWidth = Math.ceil(this.scaledWidthD);
        this.scaledHeight = Math.ceil(this.scaledHeightD);
    }

    public void computeFlexScale(double scaleFactorCoef) {
        int width = this.mc.field_71443_c;
        int height = this.mc.field_71440_d;
        double w = (double)(this.bookBackground.getWidth() + 2 * this.bookBackground.getBookScaleMargin()) / scaleFactorCoef;
        double h = (double)(this.bookBackground.getHeight() + 2 * this.bookBackground.getBookScaleMargin()) / scaleFactorCoef;
        double scale = Math.min((double)width / w, (double)height / h);
        this.scaledWidth = this.scaledWidthD = (double)width / scale;
        this.scaledHeight = this.scaledHeightD = (double)height / scale;
    }

    public static boolean epsilonEquals(double a, double b) {
        return Math.abs(b - a) < (double)1.0E-5f;
    }

    @Override
    public boolean refreshScalingFactor() {
        double oldScale = this.scalingFactor;
        double fontSize = this.book.getFontSize();
        if (ConfigValues.flexibleScale) {
            this.computeFlexScale(fontSize);
            this.hasScale = true;
        } else if (!BookRendering.epsilonEquals(fontSize, 1.0)) {
            this.computeBookScale(fontSize);
            this.hasScale = true;
        }
        if (this.hasScale) {
            this.scalingFactor = Math.min((double)this.gui.field_146294_l / this.scaledWidth, (double)this.gui.field_146295_m / this.scaledHeight);
            this.bookWidth = (int)((double)this.bookBackground.getWidth() / fontSize);
            this.bookHeight = (int)((double)this.bookBackground.getHeight() / fontSize);
            this.innerMargin = (int)((double)this.bookBackground.getInnerMargin() / fontSize);
            this.outerMargin = (int)((double)this.bookBackground.getOuterMargin() / fontSize);
            this.topMargin = (int)((double)this.bookBackground.getTopMargin() / fontSize);
            this.bottomMargin = (int)((double)this.bookBackground.getBottomMargin() / fontSize);
        } else {
            this.hasScale = false;
            this.scalingFactor = 1.0;
            this.scaledWidth = this.gui.field_146294_l;
            this.scaledHeight = this.gui.field_146295_m;
            this.bookWidth = this.bookBackground.getWidth();
            this.bookHeight = this.bookBackground.getHeight();
            this.innerMargin = this.bookBackground.getInnerMargin();
            this.outerMargin = this.bookBackground.getOuterMargin();
            this.topMargin = this.bookBackground.getTopMargin();
            this.bottomMargin = this.bookBackground.getBottomMargin();
        }
        switch (this.bookBackground.getLayout()) {
            case ONE_PAGE: {
                this.pageWidth = this.bookWidth - this.innerMargin - this.outerMargin;
                break;
            }
            case TWO_PAGES: {
                this.pageWidth = this.bookWidth / 2 - this.innerMargin - this.outerMargin;
            }
        }
        this.pageHeight = this.bookHeight - this.topMargin - this.bottomMargin;
        return !BookRendering.epsilonEquals(this.scalingFactor, oldScale);
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    private void pushHistory() {
        this.history.push(new PageRef(this.currentChapter, this.currentPage));
    }

    @Override
    public boolean canGoNextPage() {
        return this.getNextPage() >= 0 || this.canGoNextChapter();
    }

    @Override
    public void nextPage() {
        int pg = this.getNextPage();
        if (pg >= 0) {
            this.pushHistory();
            this.currentPage = pg;
        } else {
            this.nextChapter();
        }
    }

    @Override
    public boolean canGoPrevPage() {
        return this.getPrevPage() >= 0 || this.canGoPrevChapter();
    }

    @Override
    public void prevPage() {
        int pg = this.getPrevPage();
        if (pg >= 0) {
            this.pushHistory();
            this.currentPage = pg;
        } else {
            this.prevChapter(true);
        }
    }

    @Override
    public boolean canGoNextChapter() {
        return this.getNextChapter() >= 0;
    }

    @Override
    public void nextChapter() {
        int ch = this.getNextChapter();
        if (ch >= 0) {
            this.pushHistory();
            this.currentPage = 0;
            this.currentChapter = ch;
        }
    }

    @Override
    public boolean canGoPrevChapter() {
        return this.getPrevChapter() >= 0;
    }

    @Override
    public void prevChapter() {
        this.prevChapter(false);
    }

    private void prevChapter(boolean lastPage) {
        int ch = this.getPrevChapter();
        if (ch >= 0) {
            this.pushHistory();
            this.currentPage = 0;
            this.currentChapter = ch;
            if (lastPage) {
                switch (this.bookBackground.getLayout()) {
                    case ONE_PAGE: {
                        this.currentPage = this.getVisualChapter((int)ch).totalPages - 1;
                        break;
                    }
                    case TWO_PAGES: {
                        this.currentPage = this.getVisualChapter((int)ch).totalPages - 2;
                    }
                }
            }
        }
    }

    @Override
    public boolean canGoBack() {
        return this.history.size() > 0;
    }

    @Override
    public void navigateBack() {
        if (this.history.size() > 0) {
            PageRef target = this.history.pop();
            this.currentChapter = target.chapter;
            this.currentPage = target.page / 2;
        } else {
            this.currentChapter = 0;
            this.currentPage = 0;
        }
    }

    @Override
    public void navigateHome() {
        if (this.book.home != null) {
            this.navigateTo(this.book.home);
        }
    }

    private int getNextChapter() {
        for (int i = this.currentChapter + 1; i < this.book.chapterCount(); ++i) {
            if (!this.needChapter(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPrevChapter() {
        for (int i = this.currentChapter - 1; i >= 0; --i) {
            if (!this.needChapter(i)) continue;
            return i;
        }
        return -1;
    }

    private int getNextPage() {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        switch (this.bookBackground.getLayout()) {
            case ONE_PAGE: {
                if (this.currentPage + 1 >= ch.totalPages) {
                    return -1;
                }
                return this.currentPage + 1;
            }
            case TWO_PAGES: {
                if (this.currentPage + 2 >= ch.totalPages) {
                    return -1;
                }
                return this.currentPage + 2;
            }
        }
        return 0;
    }

    private int getPrevPage() {
        switch (this.bookBackground.getLayout()) {
            case ONE_PAGE: {
                if (this.currentPage - 1 < 0) {
                    return -1;
                }
                return this.currentPage - 1;
            }
            case TWO_PAGES: {
                if (this.currentPage - 2 < 0) {
                    return -1;
                }
                return this.currentPage - 2;
            }
        }
        return 0;
    }

    private boolean needChapter(int chapterNumber) {
        if (chapterNumber < 0 || chapterNumber >= this.book.chapterCount()) {
            return false;
        }
        BookDocument.ChapterData ch = this.book.getChapter(chapterNumber);
        return ch.conditionResult && !ch.isEmpty();
    }

    private boolean needSection(int chapterNumber, int sectionNumber) {
        BookDocument.ChapterData ch = this.book.getChapter(chapterNumber);
        if (sectionNumber < 0 || sectionNumber >= ch.sections.size()) {
            return false;
        }
        BookDocument.PageData section = ch.sections.get(sectionNumber);
        return section.conditionResult && !section.isEmpty();
    }

    private int findSectionStart(SectionRef ref) {
        VisualChapter vc = this.getVisualChapter(this.currentChapter);
        for (int i = 0; i < vc.pages.size(); ++i) {
            VisualPage page = vc.pages.get(i);
            if (page.ref.section == ref.section) {
                return i;
            }
            if (page.ref.section <= ref.section) continue;
            return 0;
        }
        return 0;
    }

    @Override
    public void navigateTo(SectionRef target) {
        if (!target.resolve(this.book)) {
            return;
        }
        this.pushHistory();
        if (!this.needChapter(target.chapter)) {
            return;
        }
        if (!this.needSection(target.chapter, target.section)) {
            return;
        }
        this.currentChapter = target.chapter;
        this.currentPage = this.findSectionStart(target);
    }

    private VisualChapter getVisualChapter(int chapter) {
        while (this.chapters.size() <= chapter && this.lastProcessedChapter < this.book.chapterCount()) {
            BookDocument.ChapterData bc = this.book.getChapter(this.lastProcessedChapter++);
            if (!bc.conditionResult) continue;
            VisualChapter ch = new VisualChapter();
            if (this.chapters.size() > 0) {
                VisualChapter prev = this.chapters.get(this.chapters.size() - 1);
                ch.startPage = prev.startPage + prev.totalPages;
            }
            Size pageSize = new Size(this.pageWidth, this.pageHeight);
            bc.reflow(this, ch, pageSize);
            switch (this.bookBackground.getLayout()) {
                case ONE_PAGE: {
                    ch.totalPages = ch.pages.size();
                    break;
                }
                case TWO_PAGES: {
                    ch.totalPages = ch.pages.size() % 2 > 0 ? ch.pages.size() + 1 : ch.pages.size();
                }
            }
            this.chapters.add(ch);
        }
        if (chapter >= this.chapters.size()) {
            VisualChapter vc = new VisualChapter();
            vc.pages.add(new VisualPage(new SectionRef(chapter, 0)));
            return vc;
        }
        return this.chapters.get(chapter);
    }

    @Override
    public int addString(int left, int top, String s, int color, float scale) {
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        double left0 = left;
        double top0 = top;
        if (this.hasScale && ConfigValues.flexibleScale) {
            PointD pt = this.getPageOffset(this.currentPageOnLeftSide);
            left0 = Math.floor((pt.x + (double)left) * this.scalingFactor) / this.scalingFactor - pt.x;
            top0 = Math.floor((pt.y + (double)top) * this.scalingFactor) / this.scalingFactor - pt.y;
        }
        if (this.hasScale && ConfigValues.flexibleScale || !MathHelper.func_180185_a((float)scale, (float)1.0f)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)left0, (double)top0, (double)0.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            fontRenderer.func_78276_b(s, 0, 0, color);
            GlStateManager.func_179121_F();
        } else {
            fontRenderer.func_78276_b(s, left, top, color);
        }
        return fontRenderer.field_78288_b;
    }

    @Override
    public boolean mouseClicked(int mouseButton) {
        Minecraft mc = Minecraft.func_71410_x();
        double dw = this.scaledWidth;
        double dh = this.scaledHeight;
        double mouseX = (double)Mouse.getX() * dw / (double)mc.field_71443_c;
        double mouseY = dh - (double)Mouse.getY() * dh / (double)mc.field_71440_d;
        if (mouseButton == 0) {
            VisualChapter ch = this.getVisualChapter(this.currentChapter);
            if (this.currentPage < ch.pages.size()) {
                VisualPage pgRight;
                VisualPage pgLeft = ch.pages.get(this.currentPage);
                if (this.mouseClickPage(mouseX, mouseY, pgLeft, true)) {
                    return true;
                }
                if (this.bookBackground.getLayout() == IBookBackground.Layout.TWO_PAGES && this.currentPage + 1 < ch.pages.size() && this.mouseClickPage(mouseX, mouseY, pgRight = ch.pages.get(this.currentPage + 1), false)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean mouseClickPage(double mX, double mY, VisualPage pg, boolean isLeftPage) {
        PointD offset = this.getPageOffset(isLeftPage);
        mX -= offset.x;
        mY -= offset.y;
        for (VisualElement e : pg.children) {
            if (!(mX >= (double)e.position.x) || !(mX <= (double)(e.position.x + e.size.width)) || !(mY >= (double)e.position.y) || !(mY <= (double)(e.position.y + e.size.height))) continue;
            e.click(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseHover(int mouseX, int mouseY) {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        if (this.currentPage < ch.pages.size()) {
            HoverContext hoverContext;
            VisualPage pgLeft = ch.pages.get(this.currentPage);
            VisualElement hovering = this.mouseHoverPage(pgLeft, true, hoverContext = new HoverContext(mouseX, mouseY));
            if (hovering == null && this.currentPage + 1 < ch.pages.size()) {
                VisualPage pgRight = ch.pages.get(this.currentPage + 1);
                hovering = this.mouseHoverPage(pgRight, false, hoverContext);
            }
            if (hovering != this.previousHovering && this.previousHovering != null) {
                this.previousHovering.mouseOut(this, hoverContext);
            }
            this.previousHovering = hovering;
            if (hovering != null) {
                hovering.mouseOver(this, hoverContext);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private VisualElement mouseHoverPage(VisualPage pg, boolean isLeftPage, HoverContext mouseCoords) {
        Minecraft mc = Minecraft.func_71410_x();
        double dw = this.scaledWidth;
        double dh = this.scaledHeight;
        double mX = (double)Mouse.getX() * dw / (double)mc.field_71443_c;
        double mY = dh - (double)Mouse.getY() * dh / (double)mc.field_71440_d;
        PointD offset = this.getPageOffset(isLeftPage);
        mouseCoords.mouseScaledX = mX -= offset.x;
        mouseCoords.mouseScaledY = mY -= offset.y;
        for (VisualElement e : pg.children) {
            if (!(mX >= (double)e.position.x) || !(mX <= (double)(e.position.x + e.size.width)) || !(mY >= (double)e.position.y) || !(mY <= (double)(e.position.y + e.size.height)) || !e.wantsHover()) continue;
            return e;
        }
        return null;
    }

    @Override
    public void drawCurrentPages() {
        if (this.hasScale) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)this.scalingFactor, (double)this.scalingFactor, (double)this.scalingFactor);
        }
        if (DEBUG_DRAW_BOUNDS) {
            int l = (int)((this.scaledWidth - (double)this.bookWidth) / 2.0);
            int t = (int)((this.scaledHeight - (double)this.bookHeight) / 2.0);
            Gui.func_73734_a((int)l, (int)t, (int)(l + this.bookWidth), (int)(t + this.bookHeight), (int)0x2F000000);
        }
        switch (this.bookBackground.getLayout()) {
            case TWO_PAGES: {
                this.drawPage(this.currentPage);
                this.drawPage(this.currentPage + 1);
                break;
            }
            case ONE_PAGE: {
                this.drawPage(this.currentPage);
            }
        }
        if (this.hasScale) {
            GlStateManager.func_179121_F();
        }
    }

    private PointD getPageOffset(boolean leftPage) {
        switch (this.bookBackground.getLayout()) {
            case ONE_PAGE: {
                double pageStartX = (this.scaledWidth - (double)this.bookWidth) / 2.0 + (double)this.innerMargin;
                double top = (this.scaledHeight - (double)this.bookHeight) / 2.0 + (double)this.topMargin;
                return new PointD(pageStartX, top);
            }
            case TWO_PAGES: {
                double left = (this.scaledWidth - (double)this.bookWidth) / 2.0 + (double)this.outerMargin;
                double right = left + (double)this.pageWidth + (double)(this.innerMargin * 2);
                double top = (this.scaledHeight - (double)this.bookHeight) / 2.0 + (double)this.topMargin;
                return new PointD(leftPage ? left : right, top);
            }
        }
        return null;
    }

    private void drawPage(int page) {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        if (page >= ch.pages.size()) {
            return;
        }
        this.currentPageOnLeftSide = (page & 1) == 0;
        VisualPage pg = ch.pages.get(page);
        PointD offset = this.getPageOffset(this.currentPageOnLeftSide);
        GlStateManager.func_179094_E();
        if (ConfigValues.flexibleScale) {
            GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        } else {
            GlStateManager.func_179109_b((float)((int)offset.x), (float)((int)offset.y), (float)0.0f);
        }
        if (DEBUG_DRAW_BOUNDS) {
            Gui.func_73734_a((int)0, (int)0, (int)this.pageWidth, (int)this.pageHeight, (int)0x3F000000);
        }
        for (VisualElement e : pg.children) {
            e.draw(this);
        }
        String cnt = String.valueOf(ch.startPage + page + 1);
        Size sz = this.measure(cnt);
        this.addString((this.pageWidth - sz.width) / 2, this.pageHeight + 8, cnt, -16777216, 1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawItemStack(int left, int top, int z, ItemStack stack, int color, float scale) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)left, (float)top, (float)z);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderHelper.func_74520_c();
        this.gui.field_146297_k.func_175599_af().func_180450_b(stack, 0, 0);
        RenderHelper.func_74518_a();
        this.gui.field_146297_k.func_175599_af().func_180453_a(this.gui.getFontRenderer(), stack, 0, 0, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    @Override
    public void drawImage(ResourceLocation loc, int x, int y, int tx, int ty, int w, int h, int tw, int th, float scale) {
        int sh;
        int sw = tw != 0 ? tw : 256;
        int n = sh = th != 0 ? th : 256;
        if (w == 0) {
            w = sw;
        }
        if (h == 0) {
            h = sh;
        }
        ResourceLocation locExpanded = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
        this.gui.getRenderEngine().func_110577_a(locExpanded);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookRendering.drawFlexible(x, y, tx, ty, w, h, sw, sh, scale);
    }

    private static void drawFlexible(int x, int y, float tx, float ty, int w, int h, int tw, int th, float scale) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float hs = (float)h * scale;
        float ws = (float)w * scale;
        float tsw = 1.0f / (float)tw;
        float tsh = 1.0f / (float)th;
        bufferbuilder.func_181662_b((double)x, (double)((float)y + hs), 0.0).func_187315_a((double)(tx * tsw), (double)((ty + (float)h) * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + ws), (double)((float)y + hs), 0.0).func_187315_a((double)((tx + (float)w) * tsw), (double)((ty + (float)h) * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + ws), (double)y, 0.0).func_187315_a((double)((tx + (float)w) * tsw), (double)(ty * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(tx * tsw), (double)(ty * tsh)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawCustomTexture(ResourceLocation loc, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, int tw, int th) {
        ResourceLocation locExpanded = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
        this.gui.getRenderEngine().func_110577_a(locExpanded);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookRendering.drawCustomQuad(dx, dy, dw, dh, sx, sy, sw, sh, tw, th);
    }

    private static void drawCustomQuad(int dx, int dy, int dw, int dh, float sx, int sy, int sw, float sh, int tw, int th) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float tsx = sx / (float)tw;
        float tsy = (float)sy / (float)th;
        float tsw = (float)sw / (float)tw;
        float tsh = sh / (float)th;
        bufferbuilder.func_181662_b((double)dx, (double)(dy + dh), 0.0).func_187315_a((double)tsx, (double)(tsy + tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)(dx + dw), (double)(dy + dh), 0.0).func_187315_a((double)(tsx + tsw), (double)(tsy + tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)(dx + dw), (double)dy, 0.0).func_187315_a((double)(tsx + tsw), (double)tsy).func_181675_d();
        bufferbuilder.func_181662_b((double)dx, (double)dy, 0.0).func_187315_a((double)tsx, (double)tsy).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void drawTooltip(ItemStack stack, int x, int y) {
        this.gui.drawTooltip(stack, x, y);
    }

    @Override
    public Size measure(String text) {
        FontRenderer font = this.gui.getFontRenderer();
        int width = font.func_78256_a(text);
        return new Size(width, font.field_78288_b);
    }

    @Override
    public List<VisualElement> measure(String text, int width, int firstLineWidth, float scale, int position, float baseline, int verticalAlignment) {
        FontRenderer font = this.gui.getFontRenderer();
        ArrayList sizes = Lists.newArrayList();
        TextMetrics.wrapFormattedStringToWidth(font, s -> {
            int width2 = font.func_78256_a(s);
            sizes.add(new VisualText((String)s, new Size((int)((float)width2 * scale), (int)((float)font.field_78288_b * scale)), position, baseline, verticalAlignment, scale));
        }, text, (float)width / scale, (float)firstLineWidth / scale, true);
        return sizes;
    }

    @Override
    public int getActualBookHeight() {
        return this.bookHeight;
    }

    @Override
    public int getActualBookWidth() {
        return this.bookWidth;
    }

    public void setGui(GuiGuidebook guiGuidebook) {
        this.gui = guiGuidebook;
    }

    private IBookBackground createBackground(GuiGuidebook guiGuidebook) {
        ResourceLocation background = this.book.getBackground();
        IBookBackgroundFactory factory = BACKGROUND_FACTORY_MAP.get(background);
        if (factory != null) {
            return factory.create(guiGuidebook, background);
        }
        return DEFAULT_BACKGROUND.create(guiGuidebook, background);
    }

    private class PageRef {
        public int chapter;
        public int page;

        public PageRef(int currentChapter, int currentPage) {
            this.chapter = currentChapter;
            this.page = currentPage;
        }
    }

    private static class TextMetrics {
        private TextMetrics() {
        }

        private static boolean isFormatColor(char colorChar) {
            return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
        }

        private static int sizeStringToWidth(FontRenderer font, String str, float wrapWidth) {
            int k;
            int i = str.length();
            int j = 0;
            int l = -1;
            boolean flag = false;
            for (k = 0; k < i; ++k) {
                char c0 = str.charAt(k);
                switch (c0) {
                    case '\n': {
                        --k;
                        break;
                    }
                    case ' ': {
                        l = k;
                    }
                    default: {
                        j += font.func_78263_a(c0);
                        if (!flag) break;
                        ++j;
                        break;
                    }
                    case '\u00a7': {
                        char c1;
                        if (k >= i - 1) break;
                        if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                            if (c1 != 'r' && c1 != 'R' && !TextMetrics.isFormatColor(c1)) break;
                            flag = false;
                            break;
                        }
                        flag = true;
                    }
                }
                if (c0 == '\n') {
                    l = ++k;
                    break;
                }
                if ((float)j > wrapWidth) break;
            }
            return k != i && l != -1 && l < k ? l : k;
        }

        private static void wrapFormattedStringToWidth(FontRenderer font, Consumer<String> dest, String str, float wrapWidth, float wrapWidthFirstLine, boolean firstLine) {
            int i = TextMetrics.sizeStringToWidth(font, str, firstLine ? wrapWidthFirstLine : wrapWidth);
            if (str.length() <= i) {
                dest.accept(str);
            } else {
                String s = str.substring(0, i);
                dest.accept(s);
                dest.accept("\n");
                char c0 = str.charAt(i);
                boolean flag = c0 == ' ' || c0 == '\n';
                String s1 = FontRenderer.func_78282_e((String)s) + str.substring(i + (flag ? 1 : 0));
                TextMetrics.wrapFormattedStringToWidth(font, dest, s1, wrapWidth, wrapWidthFirstLine, false);
            }
        }
    }
}

