/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.erdbeerbaerlp.discordrpc.DRPCLog;
import de.erdbeerbaerlp.discordrpc.Discord;
import de.erdbeerbaerlp.discordrpc.ModClass;
import de.erdbeerbaerlp.discordrpc.RPCconfig;
import de.erdbeerbaerlp.discordrpc.RequestMessage;
import de.erdbeerbaerlp.discordrpc.ScoreboardUtils;
import fr.nukerhd.hiveapi.response.games.Games;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.scoreboard.Score;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class DRPCEventHandler {
    protected static int currentOnline = -1;
    protected static int currentMax = -1;
    protected static boolean inWorld = false;
    protected static String Hypixel_LastGame = "";
    protected static String serverCustomMessage = "";
    protected static boolean usingCustomMsg = false;
    protected static boolean checkedUpdate = false;
    protected static String customIco = "cube";
    protected static int tickAmount = 120;
    private static int limboTimes = 0;

    @SubscribeEvent
    public static void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equalsIgnoreCase("discordrpc")) {
            DRPCLog.Info("Configuration has changed");
            RPCconfig.reloadConfig();
        }
    }

    @SubscribeEvent
    public static void onWorldLeave(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (ModClass.isClient && ModClass.isEnabled) {
            DRPCEventHandler.resetVars();
            Discord.setPresence(RPCconfig.NAME, "In Main Menu", "cube");
        }
    }

    private static void resetVars() {
        Discord.now = ModClass.gameStarted;
        inWorld = false;
        currentOnline = -1;
        currentMax = -1;
        Hypixel_LastGame = "-";
        serverCustomMessage = "";
        usingCustomMsg = false;
        tickAmount = 0;
        customIco = "cube";
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        block80: {
            if (ModClass.isClient) {
                if (!checkedUpdate) {
                    ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)((ModContainer)Loader.instance().getIndexedModList().get("discordrpc")));
                    if (result.status == ForgeVersion.Status.OUTDATED) {
                        event.player.func_145747_a(new TextComponentString("\u00a76[\u00a75DiscordRichPresence\u00a76]\u00a7c Update available!\n\u00a7cCurrent version: \u00a741.3.3\u00a7c, Newest: \u00a7a" + result.target + "\n\u00a7cChangelog:\n\u00a76" + (String)result.changes.get(result.target)).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, result.url)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to get newer Version")))));
                        DRPCLog.Fatal("UpdateCheck: Update Available. Download it here: https://minecraft.curseforge.com/projects/discordrichpresence/files");
                        checkedUpdate = true;
                    } else if (result.status == ForgeVersion.Status.AHEAD) {
                        event.player.func_145747_a(new TextComponentString("\u00a76[\u00a75DiscordRichPresence\u00a76]\u00a77 It looks like you are using an Development version... \n\u00a77Your version: \u00a761.3.3").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, result.url)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to get current stable Version")))));
                        DRPCLog.Fatal("UpdateCheck: Unreleased version... Assuming Development Version");
                        checkedUpdate = true;
                    } else if (result.status == ForgeVersion.Status.FAILED) {
                        event.player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a75DiscordRichPresence\u00a76]\u00a7c FAILED TO CHECK FOR UPDATES"));
                        DRPCLog.Fatal("UpdateCheck: Unable to check for updates");
                        checkedUpdate = true;
                    } else if (result.status == ForgeVersion.Status.BETA) {
                        event.player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a75DiscordRichPresence\u00a76]\u00a7a You are using an Beta Version. This may contain bugs which are being fixed."));
                        DRPCLog.Fatal("UpdateCheck: Beta");
                        checkedUpdate = true;
                    } else if (result.status == ForgeVersion.Status.BETA_OUTDATED) {
                        event.player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a75DiscordRichPresence\u00a76]\u00a7c You are using an Outdated Beta Version. This may contain bugs which are being fixed or are already fixed\n\u00a76Changelog of newer Beta:" + (String)result.changes.get(result.target)));
                        DRPCLog.Fatal("UpdateCheck: Bata_outdated");
                        checkedUpdate = true;
                    } else {
                        DRPCLog.Info("UpdateCheck: " + result.status.toString());
                        checkedUpdate = true;
                    }
                }
                if (ModClass.isEnabled) {
                    try {
                        int maxPlayers = Minecraft.func_71410_x().func_147114_u().field_147304_c;
                        int online = Minecraft.func_71410_x().func_147114_u().func_175106_d().size();
                        if (!usingCustomMsg && !serverCustomMessage.equals("") && RPCconfig.ENABLE_CUSTOM_INTEGRATION) {
                            DRPCLog.Debug("CustomMSG Applied");
                            Discord.setPresence(RPCconfig.NAME, serverCustomMessage.replace("%players%", online + "").replace("%otherpl%", online - 1 + "").replace("%dimensionName%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186065_b()).replace("%dimensionID%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186068_a() + "").replace("%biome%", Minecraft.func_71410_x().field_71439_g.field_70170_p.getBiomeForCoordsBody(Minecraft.func_71410_x().field_71439_g.func_180425_c()).func_185359_l()), customIco);
                            usingCustomMsg = true;
                        }
                        if (Minecraft.func_71410_x().func_147104_D() == null) {
                            if (tickAmount <= 0) {
                                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                                IntegratedServer iServer = Minecraft.func_71410_x().func_71401_C();
                                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                                int n = Double.valueOf(player.field_70165_t).intValue();
                                int posY = Double.valueOf(player.field_70163_u).intValue();
                                int posZ = Double.valueOf(player.field_70161_v).intValue();
                                Discord.setPresence(RPCconfig.NAME, RPCconfig.WORLD_MESSAGE.replace("%world%", iServer.func_71270_I()).replace("%coords%", "X:" + n + " Y:" + posY + " Z:" + posZ).replace("%dimensionName%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186065_b()).replace("%dimensionID%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186068_a() + "").replace("%biome%", player.field_70170_p.getBiomeForCoordsBody(player.func_180425_c()).func_185359_l()), "world");
                                tickAmount = 100;
                            } else {
                                --tickAmount;
                            }
                            break block80;
                        }
                        if (tickAmount == 0) {
                            tickAmount = 500;
                            currentMax = maxPlayers;
                            currentOnline = online;
                            if (!serverCustomMessage.isEmpty()) {
                                DRPCLog.Debug("CustomMSG Applied");
                                Discord.setPresence(RPCconfig.NAME, serverCustomMessage.replace("%players%", online + "").replace("%otherpl%", online - 1 + ""), customIco);
                                usingCustomMsg = true;
                                break block80;
                            }
                            if (Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase().contains("hypixel.net") && RPCconfig.ENABLE_HYPIXEL_INTEGRATION) {
                                String scoreboardTitle;
                                try {
                                    scoreboardTitle = DRPCEventHandler.removeFormatting(Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1).func_96678_d());
                                }
                                catch (NullPointerException e) {
                                    scoreboardTitle = "";
                                }
                                if (scoreboardTitle.equals("")) {
                                    if (limboTimes >= 10) {
                                        Discord.setPresence("Hypixel", "In Limbo", "49tz49873897485");
                                    }
                                    ++limboTimes;
                                    return;
                                }
                                limboTimes = 0;
                                if (scoreboardTitle.equals("HYPIXEL") || scoreboardTitle.equals("PROTOTYPE") || scoreboardTitle.equals("THE TNT GAMES") || scoreboardTitle.equals("ARCADE GAMES") || scoreboardTitle.equals("CLASSIC GAMES")) {
                                    scoreboardTitle = "In hub";
                                }
                                if (!scoreboardTitle.equals(Hypixel_LastGame)) {
                                    Discord.now = Instant.now().getEpochSecond();
                                }
                                Hypixel_LastGame = scoreboardTitle;
                                List<String> scoreboardLines = ScoreboardUtils.getSidebarScores(Minecraft.func_71410_x().field_71441_e.func_96441_U());
                                if (scoreboardTitle.startsWith("SKYBLOCK")) {
                                    for (String string : ScoreboardUtils.getSidebarScores(Minecraft.func_71410_x().field_71441_e.func_96441_U())) {
                                        String string2 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (!DRPCEventHandler.removeFormatting(string2).startsWith("\u23e3")) continue;
                                        String string3 = string2.replace("\u23e3", "").trim();
                                        if (string3.equalsIgnoreCase("none")) {
                                            Discord.setPresence("Hypixel", "Skyblock - Unknown place", "49tz49873897485");
                                            break;
                                        }
                                        if (string3.equalsIgnoreCase("Your island")) {
                                            Discord.setPresence("Hypixel", "Skyblock - Private Island", "49tz49873897485");
                                            break;
                                        }
                                        Discord.setPresence("Hypixel", "Skyblock - " + string3 + " (with " + (online - 1) + " players)", "49tz49873897485");
                                        break;
                                    }
                                    return;
                                }
                                if (scoreboardTitle.equals("BED WARS")) {
                                    String text = "BedWars - Unknown state! Report to mod author!";
                                    for (String line : scoreboardLines) {
                                        if ((line = DRPCEventHandler.removeFormatting(line).trim()).contains("Loot Chests:")) {
                                            text = "BedWars Hub";
                                            break;
                                        }
                                        if (line.contains("Mode:")) {
                                            text = "BedWars Lobby - Mode: " + line.replace("Mode:", "").trim() + " - " + DRPCEventHandler.removeFormatting(scoreboardLines.get(5));
                                            break;
                                        }
                                        if (line.contains("YOU")) {
                                            boolean hasBed = line.contains("\u2713") || line.contains("\u2714");
                                            boolean loose = line.contains("\u2717");
                                            if (loose) {
                                                text = "Bedwars - Game Over";
                                                break;
                                            }
                                            String t = StringUtils.substringBetween((String)line, (String)": ", (String)" YOU");
                                            text = "BedWars - Team " + line.substring(2).replace(": ", "").replace(" YOU", "").replace(t, "").trim() + " - Bed: " + (hasBed ? "Standing" : "Destroyed") + " - " + DRPCEventHandler.removeFormatting(scoreboardLines.get(4));
                                            break;
                                        }
                                        if (!line.contains("Beds Broken")) continue;
                                        text = "Bedwars - Game Over";
                                    }
                                    DRPCLog.Debug(text);
                                    if (text.equals("BedWars - Unknown state! Report to mod author!")) {
                                        DRPCLog.Fatal("Unknown State!!!");
                                        for (String l : scoreboardLines) {
                                            DRPCLog.Fatal(DRPCEventHandler.removeFormatting(l));
                                        }
                                    }
                                    Discord.setPresence("Hypixel", text, "49tz49873897485");
                                    return;
                                }
                                if (scoreboardTitle.equals("FARM HUNT")) {
                                    for (String string : scoreboardLines) {
                                        String string4 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (string4.contains("Players:")) {
                                            Discord.setPresence("Hypixel", "Farm Hunt - Lobby", "49tz49873897485");
                                            return;
                                        }
                                        if (string4.equals("Hunter")) {
                                            Discord.setPresence("Hypixel", "Farm Hunt - In Game - Hunter", "49tz49873897485");
                                            return;
                                        }
                                        if (!string4.contains("Disguise:")) continue;
                                        Discord.setPresence("Hypixel", "Farm Hunt - In Game - Animal", "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("HOUSING")) {
                                    for (int i = 0; i < scoreboardLines.size(); ++i) {
                                        String string = DRPCEventHandler.removeFormatting(scoreboardLines.get(i)).trim();
                                        if (string.equals("House Name:")) {
                                            Discord.setPresence("Hypixel", "Housing - Visiting " + DRPCEventHandler.removeFormatting(scoreboardLines.get(i - 1)), "49tz49873897485");
                                            return;
                                        }
                                        if (!string.equals("Visiting Rules:")) continue;
                                        Discord.setPresence("Hypixel", "Housing - At Home", "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("TURBO KART RACERS")) {
                                    for (String string : scoreboardLines) {
                                        String string5 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (!string5.contains("Map:")) continue;
                                        Discord.setPresence("Hypixel", "Turbo Kart Racers - Lobby", "49tz49873897485");
                                        return;
                                    }
                                    for (Score score : Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96528_e()) {
                                        if (!score.func_96645_d().equals(Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1))) continue;
                                        System.out.println(DRPCEventHandler.removeFormatting(score.func_96653_e()));
                                        if (DRPCEventHandler.removeFormatting(score.func_96653_e()).contains(Minecraft.func_71410_x().field_71439_g.getDisplayNameString().substring(0, 12).trim())) {
                                            Discord.setPresence("Hypixel", "Turbo Kart Racers - In Game - Position: " + DRPCEventHandler.removeFormatting(score.func_96653_e()).charAt(0), "49tz49873897485");
                                            return;
                                        }
                                        if (!DRPCEventHandler.removeFormatting(score.func_96653_e()).contains("You're")) continue;
                                        Discord.setPresence("Hypixel", "Turbo Kart Racers - Finished - Position: " + DRPCEventHandler.removeFormatting(score.func_96653_e()).replace("You're #", "").trim(), "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("SKYWARS")) {
                                    for (String string : scoreboardLines) {
                                        String string6 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (string6.contains("Loot Chests:")) {
                                            Discord.setPresence("Hypixel", "SkyWars - Hub", "49tz49873897485");
                                            return;
                                        }
                                        if (string6.contains("Players:")) {
                                            Discord.setPresence("Hypixel", "SkyWars - Lobby", "49tz49873897485");
                                            return;
                                        }
                                        if (!string6.contains("Kills:")) continue;
                                        Discord.setPresence("Hypixel", "SkyWars - In Game - " + string6, "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("MEGA WALLS")) {
                                    for (String string : scoreboardLines) {
                                        String string7 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (string7.contains("Coins:")) {
                                            Discord.setPresence("Hypixel", "Mega Walls - Hub", "49tz49873897485");
                                            return;
                                        }
                                        if (string7.contains("Players:")) {
                                            Discord.setPresence("Hypixel", "Mega Walls - Lobby", "49tz49873897485");
                                            return;
                                        }
                                        if (!string7.contains("Kills / Assists:")) continue;
                                        Discord.setPresence("Hypixel", "Mega Walls - In Game - " + string7, "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("BUILD BATTLE")) {
                                    for (String string : scoreboardLines) {
                                        String string8 = DRPCEventHandler.removeFormatting(string).trim();
                                        if (string8.contains("Coins:")) {
                                            Discord.setPresence("Hypixel", "Build Battle - Hub", "49tz49873897485");
                                            return;
                                        }
                                        if (string8.contains("Starting in") || string8.contains("Waiting...")) {
                                            Discord.setPresence("Hypixel", "Build Battle - Lobby", "49tz49873897485");
                                            return;
                                        }
                                        if (string8.contains("Vote Now")) {
                                            Discord.setPresence("Hypixel", "Build Battle - Voting Theme", "49tz49873897485");
                                            return;
                                        }
                                        if (string8.contains("Time:")) {
                                            Discord.setPresence("Hypixel", "Build Battle - In Game - " + string8, "49tz49873897485");
                                            return;
                                        }
                                        if (!string8.contains("Vote:")) continue;
                                        Discord.setPresence("Hypixel", "Build Battle - Voting", "49tz49873897485");
                                        return;
                                    }
                                }
                                if (scoreboardTitle.equals("MURDER MYSTERY")) {
                                    for (String string : scoreboardLines) {
                                        String string9 = DRPCEventHandler.removeFormatting(string);
                                        if (string9.contains("Loot Chests:")) {
                                            Discord.setPresence("Hypixel", "Murder Mystery - Hub", "49tz49873897485");
                                            return;
                                        }
                                        if (string9.contains("Mode:")) {
                                            Discord.setPresence("Hypixel", "Murder Mystery - Game Lobby - " + string9, "49tz49873897485");
                                            return;
                                        }
                                        if (!string9.contains("Role:")) continue;
                                        Discord.setPresence("Hypixel", "Murder Mystery - In Game - " + string9 + " - " + DRPCEventHandler.removeFormatting(scoreboardLines.get(6)), "49tz49873897485");
                                        return;
                                    }
                                    return;
                                }
                                if (scoreboardTitle.equals("THE HYPIXEL PIT")) {
                                    String text = "";
                                    for (String s : scoreboardLines) {
                                        if (!s.contains("Status:")) continue;
                                        int level = DRPCEventHandler.removeFormatting(s).equalsIgnoreCase("Status: Event") ? 6 : 7;
                                        text = DRPCEventHandler.removeFormatting(s + " - " + scoreboardLines.get(level).replace("[", "").replace("]", "")).trim();
                                    }
                                    Discord.setPresence("Hypixel", "The Pit - " + text, "49tz49873897485");
                                    return;
                                }
                                Discord.setPresence("Hypixel", scoreboardTitle + " with " + (online - 1) + " other players", "49tz49873897485");
                                break block80;
                            }
                            if (Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase().contains("mineplex.com") && RPCconfig.ENABLE_CUSTOM_INTEGRATION) {
                                Discord.setPresence(RPCconfig.NAME, "Playing on Mineplex with " + (online - 1) + " other players", "23498365347867869");
                                break block80;
                            }
                            if (Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase().contains("wynncraft.com") && RPCconfig.ENABLE_CUSTOM_INTEGRATION) {
                                Discord.setPresence(RPCconfig.NAME, "Playing on Wynncraft, The Minecraft MMORPG", "4878hz4389634tz987");
                                break block80;
                            }
                            if (Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase().contains("hivemc.com") && RPCconfig.ENABLE_HIVEMC_INTEGRATION) {
                                try {
                                    String gameO;
                                    JsonParser parse = new JsonParser();
                                    URL gameURL = new URL("https://api.hivemc.com/v1/player/" + Minecraft.func_71410_x().field_71439_g.func_70005_c_() + "/status/raw?v=1");
                                    HttpURLConnection gameConn = (HttpURLConnection)gameURL.openConnection();
                                    gameConn.setRequestProperty("User-Agent", "ErdbeerbaerLP-DiscordRichPresence-Mod");
                                    InputStream inputStream = gameConn.getInputStream();
                                    BufferedReader r = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                                    String result = r.lines().collect(Collectors.joining());
                                    JsonElement json = parse.parse(result);
                                    gameConn.disconnect();
                                    String gameS = json.getAsJsonObject().get("status").getAsString();
                                    try {
                                        gameO = Games.valueOf(gameS).getName();
                                    }
                                    catch (IllegalArgumentException e) {
                                        gameO = gameS;
                                    }
                                    if (gameO.equals("HUB")) {
                                        gameO = "in HUB";
                                    }
                                    if (gameO.equals("BEDT")) {
                                        gameO = "BedWars";
                                    }
                                    Discord.setPresence("TheHive", "Playing " + gameO + " on hivemc.com", "38462896734683686");
                                }
                                catch (Exception parse) {}
                                break block80;
                            }
                            int posX = Double.valueOf(Minecraft.func_71410_x().field_71439_g.field_70165_t).intValue();
                            int posY = Double.valueOf(Minecraft.func_71410_x().field_71439_g.field_70163_u).intValue();
                            int posZ = Double.valueOf(Minecraft.func_71410_x().field_71439_g.field_70161_v).intValue();
                            Discord.setPresence(RPCconfig.NAME, RPCconfig.SERVER_MESSAGE.replace("%ip%", Minecraft.func_71410_x().func_147104_D().field_78845_b).replace("%dimensionName%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186065_b()).replace("%dimensionID%", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186068_a() + "").replace("%biome%", Minecraft.func_71410_x().field_71439_g.field_70170_p.getBiomeForCoordsBody(Minecraft.func_71410_x().field_71439_g.func_180425_c()).func_185359_l()).replace("%online%", online + "").replace("%max%", maxPlayers + "").replace("%otherpl%", online - 1 + "").replace("%coords%", "X:" + posX + " Y:" + posY + " Z:" + posZ), "cube");
                            break block80;
                        }
                        tickAmount = tickAmount < 0 ? 2000 : --tickAmount;
                    }
                    catch (Exception e) {
                        DRPCLog.Error("(Usually not a bug) ERROR in onPlayerTick... " + e);
                    }
                }
            }
        }
    }

    public static String removeFormatting(String formatted) {
        return formatted.replaceAll("\u00a70", "").replaceAll("\u00a71", "").replaceAll("\u00a72", "").replaceAll("\u00a73", "").replaceAll("\u00a74", "").replaceAll("\u00a75", "").replaceAll("\u00a76", "").replaceAll("\u00a77", "").replaceAll("\u00a78", "").replaceAll("\u00a79", "").replaceAll("\u00a7a", "").replaceAll("\u00a7b", "").replaceAll("\u00a7c", "").replaceAll("\u00a7d", "").replaceAll("\u00a7e", "").replaceAll("\u00a7f", "").replaceAll("\u00a7l", "").replaceAll("\u00a7k", "").replaceAll("\u00a7m", "").replaceAll("\u00a7n", "").replaceAll("\u00a7o", "").replaceAll("\u00a7r", "").replaceAll("\u00a7A", "").replaceAll("\u00a7B", "").replaceAll("\u00a7C", "").replaceAll("\u00a7D", "").replaceAll("\u00a7E", "").replaceAll("\u00a7F", "").replaceAll("\u00a7L", "").replaceAll("\u00a7K", "").replaceAll("\u00a7M", "").replaceAll("\u00a7N", "").replaceAll("\u00a7O", "").replaceAll("\u00a7R", "");
    }

    @SubscribeEvent
    public static void onMenuOpened(GuiOpenEvent event) {
        if (ModClass.isClient && ModClass.isEnabled) {
            if (event.getGui() != null) {
                String guiName = event.getGui().toString().split("@")[0];
                DRPCLog.Debug("GUI: " + guiName);
            }
            if ((event.getGui() instanceof GuiMainMenu || event.getGui() instanceof GuiMultiplayer) && !inWorld) {
                DRPCEventHandler.resetVars();
                checkedUpdate = false;
                Discord.setPresence(RPCconfig.NAME, RPCconfig.MAIN_MENU_TEXT, "cube");
            } else if (event.getGui() instanceof GuiDownloadTerrain) {
                if (RPCconfig.ENABLE_CUSTOM_INTEGRATION) {
                    ModClass.REQUEST.sendToServer((IMessage)new RequestMessage("DRPC-Message-Request"));
                }
                currentOnline = -1;
                currentMax = -1;
                if (Minecraft.func_71410_x().func_147104_D() != null && Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase().contains("hypixel.net")) {
                    DRPCEventHandler.resetVars();
                }
            }
        }
    }
}

