/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.RedCommand;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import sandro.Core.PatchRegistry.Registry;

public class RedCommandEventHandler {
    public static MinecraftServer server;
    private static boolean weather;
    private static boolean nightfall;
    private static boolean mobSpawning;

    public static void setWeather(boolean enabled) {
        weather = enabled;
        RedCommandEventHandler.saveSaveData();
    }

    public static void setNightFall(boolean enabled) {
        nightfall = enabled;
        RedCommandEventHandler.saveSaveData();
    }

    public static void setMobSpawning(boolean enabled) {
        mobSpawning = enabled;
        RedCommandEventHandler.saveSaveData();
    }

    public static void loadSaveData() {
        NBTTagCompound tag = Registry.SAVE.getSaveData(server.func_130014_f_(), "RedCommands");
        if (tag.func_74764_b("weather")) {
            weather = tag.func_74767_n("weather");
        }
        if (tag.func_74764_b("nightfall")) {
            nightfall = tag.func_74767_n("nightfall");
        }
        if (tag.func_74764_b("mobSpawning")) {
            mobSpawning = tag.func_74767_n("mobSpawning");
        }
    }

    public static void saveSaveData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("weather", weather);
        tag.func_74757_a("nightfall", nightfall);
        tag.func_74757_a("mobSpawning", mobSpawning);
        Registry.SAVE.setSaveData(server.func_130014_f_(), "RedCommands", tag);
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ServerTickEvent event) {
        if (!nightfall) {
            this.setAllWorldTimes(3000);
        }
        if (!weather) {
            WorldServer world = RedCommandEventHandler.server.field_71305_c[0];
            WorldInfo worldinfo = world.func_72912_H();
            worldinfo.func_176142_i(3000);
            worldinfo.func_76080_g(0);
            worldinfo.func_76090_f(0);
            worldinfo.func_76084_b(false);
            worldinfo.func_76069_a(false);
        }
    }

    @SubscribeEvent
    public void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!mobSpawning) {
            event.setResult(Event.Result.DENY);
        }
    }

    protected void setAllWorldTimes(int time) {
        if (server == null) {
            return;
        }
        for (int i = 0; i < RedCommandEventHandler.server.field_71305_c.length; ++i) {
            RedCommandEventHandler.server.field_71305_c[i].func_72877_b((long)time);
        }
    }

    static {
        weather = true;
        nightfall = true;
        mobSpawning = true;
    }
}

