/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;

public class RotationVector {
    public double x;
    public double y;
    public double z;

    public RotationVector(BlockPos origin, BlockPos pos) {
        this.x = pos.func_177958_n() - origin.func_177958_n();
        this.y = pos.func_177956_o() - origin.func_177956_o();
        this.z = pos.func_177952_p() - origin.func_177952_p();
    }

    public RotationVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public RotationVector(EnumFacing.Axis axis, int radius) {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        if (axis == EnumFacing.Axis.X) {
            this.y = radius;
        } else {
            this.x = radius;
        }
    }

    public BlockPos getBlockPos(BlockPos origin) {
        int x1 = origin.func_177958_n() + this.drop(this.x, 0.5);
        int y1 = origin.func_177956_o() + this.drop(this.y, 0.5);
        int z1 = origin.func_177952_p() + this.drop(this.z, 0.5);
        return new BlockPos(x1, y1, z1);
    }

    @Nullable
    public BlockPos getBlockPos(BlockPos origin, EnumFacing.Axis axis) {
        double r = this.radius(axis, this.drop(this.x, 0.5), this.drop(this.y, 0.5), this.drop(this.z, 0.5));
        double r1 = r - (double)Math.round(this.radius(axis));
        if (r1 > -0.5 && r1 <= 0.5) {
            return this.getBlockPos(origin);
        }
        return null;
    }

    private int drop(double n, double v) {
        if (Math.abs(n) <= v) {
            return 0;
        }
        int sign = 1;
        if (n < 0.0) {
            sign = -1;
        }
        double n1 = Math.abs(n) - v;
        return this.round(n1 * (double)sign);
    }

    private int round(double n) {
        if (Math.abs(n) - Math.abs(n % 1.0) >= 0.25) {
            if (n >= 0.0) {
                return (int)Math.floor(Math.abs(n)) + 1;
            }
            return ((int)Math.floor(Math.abs(n)) + 1) * -1;
        }
        if (n >= 0.0) {
            return (int)Math.floor(Math.abs(n));
        }
        return (int)Math.floor(Math.abs(n)) * -1;
    }

    public RotationVector offset(RotationVector vec) {
        return this.offset(vec.x, vec.y, vec.z);
    }

    public RotationVector offset(double x, double y, double z) {
        return new RotationVector(this.x + x, this.y + y, this.z + z);
    }

    public RotationVector rotate(EnumFacing.Axis axis, EnumRotate direction, double angle) {
        return this.rotate(axis, direction == EnumRotate.counterclockwise ? this.toRadians(axis, 360.0) - angle : angle);
    }

    private RotationVector rotate(EnumFacing.Axis axis, double angle) {
        if (axis == EnumFacing.Axis.X) {
            return this.rotateX(angle);
        }
        if (axis == EnumFacing.Axis.Y) {
            return this.rotateY(angle);
        }
        return this.rotateZ(angle);
    }

    private RotationVector rotateX(double a) {
        double y1 = this.y * Math.cos(a) - this.z * Math.sin(a);
        double z1 = this.y * Math.sin(a) + this.z * Math.cos(a);
        return new RotationVector(this.x, y1, z1);
    }

    private RotationVector rotateY(double a) {
        double x1 = this.x * Math.cos(a) + this.z * Math.sin(a);
        double z1 = -this.x * Math.sin(a) + this.z * Math.cos(a);
        return new RotationVector(x1, this.y, z1);
    }

    private RotationVector rotateZ(double a) {
        double x1 = this.x * Math.cos(a) - this.y * Math.sin(a);
        double y1 = this.x * Math.sin(a) + this.y * Math.cos(a);
        return new RotationVector(x1, y1, this.z);
    }

    public static double radius(double a, double b) {
        return Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
    }

    public static double toRadians(double radius, double a) {
        return a / 180.0 * radius * Math.PI;
    }

    public double radius(EnumFacing.Axis axis) {
        return this.radius(axis, this.x, this.y, this.z);
    }

    public double radius(EnumFacing.Axis axis, double x, double y, double z) {
        if (axis == EnumFacing.Axis.X) {
            return RotationVector.radius(y, z);
        }
        if (axis == EnumFacing.Axis.Y) {
            return RotationVector.radius(x, z);
        }
        return RotationVector.radius(x, y);
    }

    public double toRadians(EnumFacing.Axis axis, double a) {
        return RotationVector.toRadians(this.radius(axis), a);
    }

    public double getAngle(EnumFacing.Axis axis) {
        double k;
        double h;
        if (axis == EnumFacing.Axis.X) {
            h = this.y;
            k = this.z;
        } else if (axis == EnumFacing.Axis.Y) {
            h = this.x;
            k = this.z;
        } else {
            h = this.x;
            k = this.y;
        }
        double a = Math.toDegrees(Math.atan2(h, k));
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }
}

