/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators.RotationVector;

public class BlockRotatorStructureHelper {
    private final World world;
    private final BlockPos rotatorPos;
    private final BlockPos blockToMove;
    private final EnumFacing rotatorFacing;
    private final EnumFacing.Axis rotatorAxis;
    private final EnumRotate rotatorDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final List<BlockPos> collisionList = Lists.newArrayList();
    private final HashMap<BlockPos, IBlockState> finalStateMap = new HashMap();

    public BlockRotatorStructureHelper(World world, BlockPos pos, BlockPos movePos, EnumFacing facing, EnumRotate direction) {
        this.world = world;
        this.rotatorPos = pos;
        this.blockToMove = movePos;
        this.rotatorFacing = facing;
        this.rotatorAxis = facing.func_176740_k();
        this.rotatorDirection = direction;
    }

    public boolean canMove() {
        this.toMove.clear();
        this.toDestroy.clear();
        IBlockState state = this.world.func_180495_p(this.blockToMove);
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        TileEntity tileEntity = null;
        if (state.func_177230_c().hasTileEntity(state)) {
            tileEntity = this.world.func_175625_s(this.blockToMove);
        }
        if (!movable.canRotate(this.world, state, tileEntity, this.blockToMove, this.blockToMove, this.rotatorAxis, this.rotatorDirection, this.rotatorFacing.func_176734_d()) || !ModulePistons.push_te && state.func_177230_c().hasTileEntity(state)) {
            if (movable.isDestroyedOnMove(this.world, state, tileEntity, this.blockToMove)) {
                if (this.rotatorFacing == EnumFacing.UP) {
                    this.toDestroy.add(this.blockToMove);
                }
                return true;
            }
            return false;
        }
        this.toMove.add(this.blockToMove);
        if (movable.isSticky(state, tileEntity) && !this.addBranchingBlocks(this.world, state, tileEntity, movable, this.blockToMove)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            if (this.addBlockLine(this.world, this.collisionList, this.rotatorPos, this.toMove.get(i), this.rotatorAxis, this.rotatorDirection)) continue;
            return false;
        }
        this.addToDestroyList(this.world);
        return true;
    }

    private boolean addBranchingBlocks(World world, IBlockState state, TileEntity tileEntity, IMovable imovable, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos other_pos = pos.func_177972_a(enumfacing);
            if (this.rotatorPos.equals((Object)other_pos) || this.toMove.contains(other_pos) || !imovable.isSideSticky(world, state, tileEntity, pos, enumfacing)) continue;
            IBlockState other_state = this.world.func_180495_p(other_pos);
            Block other_block = other_state.func_177230_c();
            IMovable other_movable = MovableRegistry.getIMovable(other_block);
            TileEntity other_tileEntity = null;
            if (other_block.hasTileEntity(other_state)) {
                if (!ModulePistons.push_te) {
                    return false;
                }
                other_tileEntity = this.world.func_175625_s(other_pos);
            }
            if (other_block.isAir(other_state, (IBlockAccess)world, other_pos) || !other_movable.canMove(world, other_state, other_tileEntity, other_pos) || !other_movable.willSideStick(this.world, other_state, other_tileEntity, other_pos, enumfacing.func_176734_d())) continue;
            if (other_movable.canRotate(world, other_state, other_tileEntity, other_pos, BlockRotatorStructureHelper.rotateBlockPos(this.rotatorPos, other_pos, this.rotatorAxis, this.rotatorDirection), this.rotatorAxis, this.rotatorDirection, enumfacing.func_176734_d())) {
                if (this.toMove.size() >= ModulePistons.push_limit) {
                    return false;
                }
                this.toMove.add(other_pos);
                if (!other_movable.isSticky(other_state, other_tileEntity) || this.addBranchingBlocks(world, other_state, other_tileEntity, other_movable, other_pos)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void addToDestroyList(World world) {
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i).func_177972_a(EnumFacing.UP);
            IBlockState state = world.func_180495_p(pos);
            IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
            TileEntity tileEntity = null;
            if (state.func_177230_c().hasTileEntity(state)) {
                tileEntity = world.func_175625_s(pos);
            }
            if (this.toDestroy.contains(pos) || !movable.isDestroyedOnMove(world, state, tileEntity, pos) || movable.getAttachedSide(world, state, tileEntity, pos) != EnumFacing.DOWN) continue;
            this.toDestroy.add(pos);
        }
    }

    public IBlockState getFinalState(BlockPos pos) {
        if (this.finalStateMap.containsKey(pos)) {
            return this.finalStateMap.get(pos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void setFinalState(BlockPos pos, IBlockState state) {
        if (this.finalStateMap.containsKey(pos)) {
            this.finalStateMap.remove(pos);
        }
        this.finalStateMap.put(pos, state);
    }

    public IBlockState rotateBlock(IBlockState state, NBTTagCompound compound, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction) {
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        IBlockState iblockstate = movable.rotate(state, compound, pos, axis, direction.reverse());
        return iblockstate;
    }

    public List<BlockPos> getBlocksToMove() {
        return this.toMove;
    }

    public List<BlockPos> getBlocksToDestroy() {
        return this.toDestroy;
    }

    public List<BlockPos> getFullList() {
        int i;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (i = 0; i < this.collisionList.size(); ++i) {
            list.add(this.collisionList.get(i));
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos2;
            BlockPos pos = this.toMove.get(i);
            if (!list.contains(pos)) {
                list.add(pos);
            }
            if (list.contains(pos2 = BlockRotatorStructureHelper.rotateBlockPos(this.rotatorPos, pos, this.rotatorAxis, this.rotatorDirection))) continue;
            list.add(pos2);
        }
        for (i = 0; i < this.toDestroy.size(); ++i) {
            if (list.contains(this.toDestroy.get(i))) continue;
            list.add(this.toDestroy.get(i));
        }
        return list;
    }

    public BlockPos getBlockCollision(World world, BlockPos origin, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction, float angle) {
        List<BlockPos> list = BlockRotatorStructureHelper.getArc(origin, pos, axis, direction.reverse(), angle);
        BlockPos pos1 = null;
        double angle1 = 361.0;
        for (int i = 0; i < list.size(); ++i) {
            double angle2;
            BlockPos pos2 = list.get(i);
            if (!this.toMove.contains(pos2) || !((angle2 = BlockRotatorStructureHelper.getAngleBetween(origin, pos, pos2, axis)) < angle1)) continue;
            pos1 = pos2;
            angle1 = angle2;
        }
        return pos1;
    }

    public static BlockPos rotateBlockPos(BlockPos orgin, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction) {
        int k;
        int h;
        if (direction == EnumRotate.counterclockwise) {
            pos = BlockRotatorStructureHelper.rotateBlockPos(orgin, pos, axis, EnumRotate.clockwise);
            pos = BlockRotatorStructureHelper.rotateBlockPos(orgin, pos, axis, EnumRotate.clockwise);
        }
        if (axis == EnumFacing.Axis.X) {
            h = pos.func_177952_p() - orgin.func_177952_p();
            k = pos.func_177956_o() - orgin.func_177956_o();
        } else if (axis == EnumFacing.Axis.Z) {
            h = pos.func_177958_n() - orgin.func_177958_n();
            k = pos.func_177956_o() - orgin.func_177956_o();
        } else {
            h = pos.func_177958_n() - orgin.func_177958_n();
            k = pos.func_177952_p() - orgin.func_177952_p();
        }
        int mh = k;
        int mk = h * -1;
        if (axis == EnumFacing.Axis.X) {
            return new BlockPos(pos.func_177958_n(), orgin.func_177956_o() + mk, orgin.func_177952_p() + mh);
        }
        if (axis == EnumFacing.Axis.Z) {
            return new BlockPos(orgin.func_177958_n() + mh, orgin.func_177956_o() + mk, pos.func_177952_p());
        }
        return new BlockPos(orgin.func_177958_n() + mh, pos.func_177956_o(), orgin.func_177952_p() + mk);
    }

    public boolean addBlockLine(World world, List<BlockPos> list, BlockPos origin, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction) {
        double a2;
        double a1;
        if (axis == EnumFacing.Axis.X) {
            direction = direction.reverse();
        }
        List<BlockPos> list1 = BlockRotatorStructureHelper.getCircle(origin, pos, axis);
        RotationVector v1 = new RotationVector(origin, pos);
        if (direction == EnumRotate.clockwise) {
            a1 = v1.getAngle(axis);
            a2 = BlockRotatorStructureHelper.clampA(a1 + 90.0);
        } else {
            a2 = v1.getAngle(axis);
            a1 = BlockRotatorStructureHelper.clampA(a2 - 90.0);
        }
        for (int i = 0; i < list1.size(); ++i) {
            BlockPos p = list1.get(i);
            RotationVector v = new RotationVector(origin, p);
            double a = v.getAngle(axis);
            if (!BlockRotatorStructureHelper.isAngleBetween(a, a1, a2) || list.contains(p) || this.toMove.contains(p) || this.toDestroy.contains(p)) continue;
            IBlockState state = world.func_180495_p(p);
            IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
            TileEntity tileEntity = null;
            if (state.func_177230_c().hasTileEntity(state)) {
                if (!ModulePistons.push_te) {
                    return false;
                }
                tileEntity = world.func_175625_s(p);
            }
            if (movable.isDestroyedOnMove(world, state, tileEntity, p)) {
                this.toDestroy.add(p);
                list.add(p);
                continue;
            }
            return false;
        }
        return true;
    }

    public static double clampA(double a) {
        if (a < 0.0) {
            return a += 360.0;
        }
        if (a > 360.0) {
            return a -= 360.0;
        }
        return a;
    }

    public static boolean isAngleBetween(double n, double a, double b) {
        if (a < b) {
            return a <= n && n <= b;
        }
        return a <= n || n <= b;
    }

    public static double getAngleBetween(BlockPos origin, BlockPos pos1, BlockPos pos2, EnumFacing.Axis axis) {
        RotationVector v1 = new RotationVector(origin, pos1);
        RotationVector v2 = new RotationVector(origin, pos2);
        return Math.min(BlockRotatorStructureHelper.clampA(v1.getAngle(axis) - v2.getAngle(axis)), BlockRotatorStructureHelper.clampA(v2.getAngle(axis) - v1.getAngle(axis)));
    }

    public static List<BlockPos> getArc(BlockPos origin, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction, float angle) {
        double a2;
        double a1;
        if (axis == EnumFacing.Axis.X) {
            direction = direction.reverse();
        }
        List<BlockPos> list1 = BlockRotatorStructureHelper.getCircle(origin, pos, axis);
        RotationVector v1 = new RotationVector(origin, pos);
        if (direction == EnumRotate.clockwise) {
            a1 = v1.getAngle(axis);
            a2 = BlockRotatorStructureHelper.clampA(a1 + (double)angle);
        } else {
            a2 = v1.getAngle(axis);
            a1 = BlockRotatorStructureHelper.clampA(a2 + (double)angle);
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < list1.size(); ++i) {
            BlockPos p = list1.get(i);
            RotationVector v = new RotationVector(origin, p);
            double a = v.getAngle(axis);
            if (!BlockRotatorStructureHelper.isAngleBetween(a, a1, a2) || list.contains(p)) continue;
            list.add(p);
        }
        return list;
    }

    private static List<BlockPos> getCircle(BlockPos origin, BlockPos pos, EnumFacing.Axis axis) {
        BlockPos o;
        double r;
        if (axis == EnumFacing.Axis.X) {
            r = RotationVector.radius(origin.func_177956_o() - pos.func_177956_o(), origin.func_177952_p() - pos.func_177952_p());
            o = new BlockPos(pos.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
        } else if (axis == EnumFacing.Axis.Y) {
            r = RotationVector.radius(origin.func_177958_n() - pos.func_177958_n(), origin.func_177952_p() - pos.func_177952_p());
            o = new BlockPos(origin.func_177958_n(), pos.func_177956_o(), origin.func_177952_p());
        } else {
            r = RotationVector.radius(origin.func_177958_n() - pos.func_177958_n(), origin.func_177956_o() - pos.func_177956_o());
            o = new BlockPos(origin.func_177958_n(), origin.func_177956_o(), pos.func_177952_p());
        }
        RotationVector v1 = new RotationVector(o, pos);
        int radius = (int)Math.round(v1.radius(axis));
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (radius < 1) {
            return list;
        }
        if (radius == 1) {
            BlockRotatorStructureHelper.add1RCircle(list, o, axis);
            return list;
        }
        RotationVector startingVector = new RotationVector(axis, radius);
        int stepCNT = (int)Math.ceil(r * Math.PI * 2.0) * 2;
        double stepSize = Math.PI * 2 / (double)stepCNT;
        for (int i = 0; i <= stepCNT; ++i) {
            RotationVector v = startingVector.rotate(axis, EnumRotate.clockwise, stepSize * (double)i);
            BlockPos p = v.getBlockPos(o, axis);
            if (p == null || list.contains(p)) continue;
            list.add(p);
        }
        BlockPos startingPos = startingVector.getBlockPos(o);
        BlockRotatorStructureHelper.addShiftBlockPos(list, o, startingPos, axis);
        BlockPos next = BlockRotatorStructureHelper.rotateBlockPos(o, startingPos, axis, EnumRotate.clockwise);
        BlockRotatorStructureHelper.addShiftBlockPos(list, o, next, axis);
        next = BlockRotatorStructureHelper.rotateBlockPos(o, next, axis, EnumRotate.clockwise);
        BlockRotatorStructureHelper.addShiftBlockPos(list, o, next, axis);
        next = BlockRotatorStructureHelper.rotateBlockPos(o, next, axis, EnumRotate.clockwise);
        BlockRotatorStructureHelper.addShiftBlockPos(list, o, next, axis);
        return list;
    }

    private static void add1RCircle(List<BlockPos> list, BlockPos origin, EnumFacing.Axis axis) {
        BlockPos e = origin.func_177972_a(EnumFacing.EAST);
        BlockPos w = origin.func_177972_a(EnumFacing.WEST);
        BlockPos u = origin.func_177972_a(EnumFacing.UP);
        BlockPos d = origin.func_177972_a(EnumFacing.DOWN);
        BlockPos n = origin.func_177972_a(EnumFacing.NORTH);
        BlockPos s = origin.func_177972_a(EnumFacing.SOUTH);
        if (axis != EnumFacing.Axis.X) {
            if (!list.contains(e)) {
                list.add(e);
            }
            if (!list.contains(w)) {
                list.add(w);
            }
        }
        if (axis != EnumFacing.Axis.Y) {
            if (!list.contains(u)) {
                list.add(u);
            }
            if (!list.contains(d)) {
                list.add(d);
            }
        }
        if (axis != EnumFacing.Axis.Z) {
            if (list.contains(n)) {
                list.add(n);
            }
            if (list.contains(s)) {
                list.add(s);
            }
        }
        if (axis == EnumFacing.Axis.X) {
            BlockPos us = u.func_177972_a(EnumFacing.SOUTH);
            BlockPos ds = d.func_177972_a(EnumFacing.SOUTH);
            BlockPos un = u.func_177972_a(EnumFacing.NORTH);
            BlockPos dn = d.func_177972_a(EnumFacing.NORTH);
            if (!list.contains(us)) {
                list.add(us);
            }
            if (!list.contains(ds)) {
                list.add(ds);
            }
            if (!list.contains(un)) {
                list.add(un);
            }
            if (!list.contains(dn)) {
                list.add(dn);
            }
        } else if (axis == EnumFacing.Axis.Y) {
            BlockPos ne = n.func_177972_a(EnumFacing.EAST);
            BlockPos se = s.func_177972_a(EnumFacing.EAST);
            BlockPos nw = n.func_177972_a(EnumFacing.WEST);
            BlockPos sw = s.func_177972_a(EnumFacing.WEST);
            if (!list.contains(ne)) {
                list.add(ne);
            }
            if (!list.contains(se)) {
                list.add(se);
            }
            if (!list.contains(nw)) {
                list.add(nw);
            }
            if (!list.contains(sw)) {
                list.add(sw);
            }
        } else {
            BlockPos ue = u.func_177972_a(EnumFacing.EAST);
            BlockPos de = d.func_177972_a(EnumFacing.EAST);
            BlockPos uw = u.func_177972_a(EnumFacing.WEST);
            BlockPos dw = d.func_177972_a(EnumFacing.WEST);
            if (!list.contains(ue)) {
                list.add(ue);
            }
            if (!list.contains(de)) {
                list.add(de);
            }
            if (!list.contains(uw)) {
                list.add(uw);
            }
            if (!list.contains(dw)) {
                list.add(dw);
            }
        }
    }

    private static void addShiftBlockPos(List<BlockPos> list, BlockPos origin, BlockPos pos, EnumFacing.Axis axis) {
        EnumFacing facing = BlockRotatorStructureHelper.getFacing(origin, pos, axis);
        if (facing != null) {
            EnumFacing c = facing.func_176732_a(axis);
            EnumFacing cc = c.func_176734_d();
            BlockPos posc = pos.func_177972_a(c);
            BlockPos poscc = pos.func_177972_a(cc);
            if (!list.contains(posc)) {
                list.add(posc);
            }
            if (!list.contains(poscc)) {
                list.add(poscc);
            }
        }
    }

    private static void addShiftBlockPos(List<BlockPos> list, BlockPos origin, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction) {
        EnumFacing facing = BlockRotatorStructureHelper.getFacing(origin, pos, axis);
        if (facing != null) {
            BlockPos p2;
            BlockPos p1;
            EnumFacing cc = facing.func_176732_a(axis);
            EnumFacing c = cc.func_176732_a(axis);
            c = c.func_176732_a(axis);
            BlockPos r = BlockRotatorStructureHelper.rotateBlockPos(origin, pos, axis, direction);
            if (direction == EnumRotate.clockwise) {
                p1 = pos.func_177972_a(c);
                p2 = r.func_177972_a(facing);
            } else {
                p1 = pos.func_177972_a(cc);
                p2 = r.func_177972_a(facing);
            }
            if (!list.contains(p1)) {
                list.add(p1);
            }
            if (!list.contains(p2)) {
                list.add(p2);
            }
        }
    }

    private static EnumFacing getFacing(BlockPos origin, BlockPos pos, EnumFacing.Axis axis) {
        int z;
        int x = axis == EnumFacing.Axis.X ? 0 : pos.func_177958_n() - origin.func_177958_n();
        int y = axis == EnumFacing.Axis.Y ? 0 : pos.func_177956_o() - origin.func_177956_o();
        int n = z = axis == EnumFacing.Axis.Z ? 0 : pos.func_177952_p() - origin.func_177952_p();
        if (x == 0 && y == 0 && z == 0) {
            return null;
        }
        if (x == 0 && y == 0) {
            if (z >= 0) {
                return EnumFacing.SOUTH;
            }
            return EnumFacing.NORTH;
        }
        if (x == 0 && z == 0) {
            if (y >= 0) {
                return EnumFacing.UP;
            }
            return EnumFacing.DOWN;
        }
        if (y == 0 && z == 0) {
            if (x >= 0) {
                return EnumFacing.EAST;
            }
            return EnumFacing.WEST;
        }
        return null;
    }

    public List<BlockPos> getChestUpdateList() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i);
            IBlockState state = this.world.func_180495_p(pos);
            Object tileEntity = null;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                BlockPos p = pos.func_177972_a(dir);
                if (list.contains(p)) continue;
                list.add(p);
            }
        }
        return list;
    }
}

