/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators.BlockRotatorMoving;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators.BlockRotatorStructureHelper;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators.TileEntityRotator;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class BlockRotatorBase
extends Block {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    private final boolean counterclockwise;
    private final boolean isSticky;

    public BlockRotatorBase(String name, CreativeTabs tab, boolean isCounterClockwise, boolean isSticky) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        Registry.PATCH.setRegistryName((Object)this, name);
        if (isCounterClockwise) {
            this.func_149647_a(tab);
        }
        if (isSticky) {
            this.func_149663_c("rotator_sticky");
        } else {
            this.func_149663_c("rotator");
        }
        this.counterclockwise = isCounterClockwise;
        this.isSticky = isSticky;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.5f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        IBlockState newState = this.counterclockwise ? (this.isSticky ? ModulePistons.ROTATOR_STICKY_CLOCKWISE.func_176223_P() : ModulePistons.ROTATOR_CLOCKWISE.func_176223_P()) : (this.isSticky ? ModulePistons.ROTATOR_STICKY.func_176223_P() : ModulePistons.ROTATOR.func_176223_P());
        world.func_175656_a(pos, newState.func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)TRIGGERED, state.func_177229_b((IProperty)TRIGGERED)));
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.isSticky) {
            return Item.func_150898_a((Block)ModulePistons.ROTATOR_STICKY);
        }
        return Item.func_150898_a((Block)ModulePistons.ROTATOR);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isSticky) {
            return new ItemStack((Block)ModulePistons.ROTATOR_STICKY);
        }
        return new ItemStack((Block)ModulePistons.ROTATOR);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        if (this.isSticky) {
            return new ItemStack((Block)ModulePistons.ROTATOR_STICKY);
        }
        return new ItemStack((Block)ModulePistons.ROTATOR);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    private void checkForMove(World world, BlockPos pos, IBlockState state) {
        boolean triggered;
        boolean powered = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        if (powered ^ (triggered = ((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue())) {
            world.func_175641_c(pos, (Block)this, 0, triggered ? 1 : 0);
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        switch (param) {
            case 0: {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
                this.doRotate(worldIn, pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)));
                return true;
            }
            case 1: {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
                if (this.isSticky) {
                    this.doRotate(worldIn, pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
                }
                return true;
            }
        }
        return false;
    }

    private boolean doRotate(World world, BlockPos pos, IBlockState state) {
        BlockPos other_pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N));
        IBlockState other = world.func_180495_p(other_pos);
        IMovable movable = MovableRegistry.getIMovable(other.func_177230_c());
        TileEntity tileEntity = null;
        if (other.func_177230_c().hasTileEntity(other)) {
            tileEntity = world.func_175625_s(other_pos);
        }
        EnumFacing.Axis axis = ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176740_k();
        boolean reverse = (Boolean)state.func_177229_b((IProperty)TRIGGERED) == false;
        EnumRotate direction = this.getRotateDirection(state).reverse(reverse);
        BlockRotatorStructureHelper blockrotatorstructurehelper = new BlockRotatorStructureHelper(world, pos, other_pos, (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N), direction);
        if (!blockrotatorstructurehelper.canMove()) {
            return false;
        }
        List<BlockPos> list = blockrotatorstructurehelper.getBlocksToMove();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos = list.get(i);
            IBlockState iblockstate = world.func_180495_p(blockpos).func_185899_b((IBlockAccess)world, blockpos);
            list1.add(iblockstate);
            BlockPos toPos = BlockRotatorStructureHelper.rotateBlockPos(pos, blockpos, axis, direction);
            blockrotatorstructurehelper.setFinalState(toPos, iblockstate);
            TileEntity tileEntity1 = null;
            if (iblockstate.func_177230_c().hasTileEntity(iblockstate)) {
                tileEntity1 = world.func_175625_s(blockpos);
                TileEntityHelper.add_tileEntity(world, toPos, tileEntity1);
            }
            IMovable imovable = MovableRegistry.getIMovable(iblockstate.func_177230_c());
            imovable.preMove(world, iblockstate, tileEntity1, TileEntityHelper.get_tileEntity(world, toPos), blockpos, toPos);
        }
        List<BlockPos> list2 = blockrotatorstructurehelper.getBlocksToDestroy();
        HashMap<BlockPos, IBlockState> updateList = new HashMap<BlockPos, IBlockState>();
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos1 = list2.get(j);
            IBlockState iblockstate1 = world.func_180495_p(blockpos1);
            float chance = iblockstate1.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
            iblockstate1.func_177230_c().func_180653_a(world, blockpos1, iblockstate1, chance, 0);
            world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 4);
            updateList.put(blockpos1, iblockstate1);
        }
        IBlockState moving = ModulePistons.ROTATOR_MOVING.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_177226_a((IProperty)BlockRotatorMoving.CLOCKWISE, (Comparable)Boolean.valueOf(!this.counterclockwise));
        List<BlockPos> fullList = blockrotatorstructurehelper.getFullList();
        for (int l = 0; l < fullList.size(); ++l) {
            BlockPos blockpos3 = fullList.get(l);
            IBlockState iblockstate3 = world.func_180495_p(blockpos3);
            IBlockState iblockstateFinal = blockrotatorstructurehelper.getFinalState(blockpos3);
            TileEntityRotator tileEntityRotator = new TileEntityRotator(iblockstate3, axis, EnumRotate.Counterclockwise(this.counterclockwise).reverse(reverse), pos, iblockstateFinal);
            world.func_180501_a(blockpos3, moving, 4);
            world.func_175690_a(blockpos3, (TileEntity)tileEntityRotator);
            updateList.put(blockpos3, iblockstate3);
        }
        world.func_180501_a(pos, moving, 4);
        TileEntityRotator tileEntityRotator1 = new TileEntityRotator(state, axis, EnumRotate.Counterclockwise(this.counterclockwise).reverse(reverse), pos, state);
        world.func_175690_a(pos, (TileEntity)tileEntityRotator1);
        tileEntityRotator1.isBase = true;
        tileEntityRotator1.isSticky = this.isSticky;
        tileEntityRotator1.baseDirection = EnumRotate.Counterclockwise(this.counterclockwise);
        for (Map.Entry entry : updateList.entrySet()) {
            world.func_175685_c((BlockPos)entry.getKey(), ((IBlockState)entry.getValue()).func_177230_c(), false);
        }
        world.func_175685_c(pos, (Block)Blocks.field_150332_K, false);
        List<BlockPos> chestUpdateList = blockrotatorstructurehelper.getChestUpdateList();
        for (int i4 = 0; i4 < chestUpdateList.size(); ++i4) {
            BlockPos posi4 = chestUpdateList.get(i4);
            IBlockState chestState = world.func_180495_p(posi4);
            if (!(chestState.func_177230_c() instanceof BlockChest)) continue;
            BlockChest blockChest = (BlockChest)chestState.func_177230_c();
            TileEntity tileEntity4 = world.func_175625_s(posi4);
            if (tileEntity4 != null && tileEntity4 instanceof TileEntityChest) {
                ((TileEntityChest)tileEntity4).func_145836_u();
                ((TileEntityChest)tileEntity4).func_145979_i();
            }
            blockChest.func_176455_e(world, posi4, chestState);
        }
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        return true;
    }

    private EnumFacing getBlockFacing(IBlockState state) {
        if (state.func_177227_a().contains(BlockDirectional.field_176387_N)) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        }
        if (state.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D)) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        }
        return null;
    }

    private EnumRotate getRotateDirection(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        if (facing == EnumFacing.SOUTH || facing == EnumFacing.WEST || facing == EnumFacing.DOWN) {
            return this.counterclockwise ? EnumRotate.counterclockwise : EnumRotate.clockwise;
        }
        return this.counterclockwise ? EnumRotate.clockwise : EnumRotate.counterclockwise;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return state.func_177229_b((IProperty)FACING) == EnumFacing.DOWN;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

