/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.HalfBlocks.BlockHalfSlime;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class TileEntityPistonFix
extends TileEntityPiston {
    private IBlockState pistonState;
    private EnumFacing pistonFacing;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    public boolean isBase = false;
    private static final ThreadLocal<EnumFacing> MOVING_ENTITY = new ThreadLocal<EnumFacing>(){

        @Override
        protected EnumFacing initialValue() {
            return null;
        }
    };
    private float progress;
    private float lastProgress;

    public TileEntityPistonFix(IBlockState pistonStateIn, EnumFacing pistonFacingIn, boolean extendingIn, boolean shouldHeadBeRenderedIn) {
        this.pistonState = pistonStateIn;
        this.pistonFacing = pistonFacingIn;
        this.extending = extendingIn;
        this.shouldHeadBeRendered = shouldHeadBeRenderedIn;
    }

    public TileEntityPistonFix(TileEntityPiston tileEntity) {
        this.pistonState = tileEntity.func_174927_b();
        this.pistonFacing = tileEntity.func_174930_e();
        this.extending = tileEntity.func_145868_b();
        this.shouldHeadBeRendered = tileEntity.func_145867_d();
    }

    public IBlockState func_174927_b() {
        return this.pistonState;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean func_145868_b() {
        return this.extending;
    }

    public EnumFacing func_174930_e() {
        return this.pistonFacing;
    }

    public boolean func_145867_d() {
        return this.shouldHeadBeRendered;
    }

    public void func_145866_f() {
        if (this.lastProgress < 1.0f && this.field_145850_b != null) {
            this.lastProgress = this.progress = 1.0f;
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_180384_M) {
                TileEntityHelper.setBlockState(this.field_145850_b, this.field_174879_c, this.pistonState);
            }
        }
    }

    public void func_73660_a() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_180384_M) {
                TileEntityHelper.setBlockState(this.field_145850_b, this.field_174879_c, this.pistonState);
            }
        } else {
            float f = this.progress + 0.5f;
            this.moveCollidedEntities(f);
            this.progress = f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.field_174879_c = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        this.pistonState = Block.func_149729_e((int)compound.func_74762_e("blockId")).func_176203_a(compound.func_74762_e("blockData"));
        this.pistonFacing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.lastProgress = this.progress = compound.func_74760_g("progress");
        this.extending = compound.func_74767_n("extending");
        this.shouldHeadBeRendered = compound.func_74767_n("source");
        this.isBase = compound.func_74767_n("base");
        if (compound.func_74764_b("tileEntity")) {
            TileEntityHelper.add_tileEntity(this.field_145850_b, this.field_174879_c, compound.func_74775_l("tileEntity"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("blockId", Block.func_149682_b((Block)this.pistonState.func_177230_c()));
        compound.func_74768_a("blockData", this.pistonState.func_177230_c().func_176201_c(this.pistonState));
        compound.func_74768_a("facing", this.pistonFacing.func_176745_a());
        compound.func_74776_a("progress", this.lastProgress);
        compound.func_74757_a("extending", this.extending);
        compound.func_74757_a("source", this.shouldHeadBeRendered);
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74757_a("base", this.isBase);
        NBTTagCompound tileEntity = TileEntityHelper.get_tileEntity(this.field_145850_b, this.field_174879_c);
        if (tileEntity != null) {
            compound.func_74782_a("tileEntity", (NBTBase)tileEntity);
        }
        return compound;
    }

    public float getProgress() {
        return this.progress;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_145860_a(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * ticks;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_174929_b(float ticks) {
        return (float)this.pistonFacing.func_82601_c() * this.getExtendedProgress(this.func_145860_a(ticks));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_174928_c(float ticks) {
        return (float)this.pistonFacing.func_96559_d() * this.getExtendedProgress(this.func_145860_a(ticks));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_174926_d(float ticks) {
        return (float)this.pistonFacing.func_82599_e() * this.getExtendedProgress(this.func_145860_a(ticks));
    }

    private float getExtendedProgress(float p_184320_1_) {
        return this.extending ? p_184320_1_ - 1.0f : 1.0f - p_184320_1_;
    }

    public AxisAlignedBB func_184321_a(IBlockAccess p_184321_1_, BlockPos p_184321_2_) {
        return this.func_184319_a(p_184321_1_, p_184321_2_, this.progress).func_111270_a(this.func_184319_a(p_184321_1_, p_184321_2_, this.lastProgress));
    }

    public AxisAlignedBB func_184319_a(IBlockAccess p_184319_1_, BlockPos p_184319_2_, float p_184319_3_) {
        p_184319_3_ = this.getExtendedProgress(p_184319_3_);
        IBlockState iblockstate = this.getCollisionRelatedBlockState();
        return iblockstate.func_185900_c(p_184319_1_, p_184319_2_).func_72317_d((double)(p_184319_3_ * (float)this.pistonFacing.func_82601_c()), (double)(p_184319_3_ * (float)this.pistonFacing.func_96559_d()), (double)(p_184319_3_ * (float)this.pistonFacing.func_82599_e()));
    }

    private IBlockState getCollisionRelatedBlockState() {
        return !this.func_145868_b() && this.func_145867_d() ? Blocks.field_150332_K.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)(this.pistonState.func_177230_c() == Blocks.field_150320_F ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT)).func_177226_a((IProperty)BlockPistonExtension.field_176387_N, this.pistonState.func_177229_b((IProperty)BlockPistonBase.field_176387_N)) : this.pistonState;
    }

    private void moveCollidedEntities(float p_184322_1_) {
        AxisAlignedBB axisalignedbb;
        List list1;
        EnumFacing enumfacing = this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d();
        double d0 = p_184322_1_ - this.progress;
        ArrayList list = Lists.newArrayList();
        this.getCollisionRelatedBlockState().func_185908_a(this.field_145850_b, BlockPos.field_177992_a, new AxisAlignedBB(BlockPos.field_177992_a), (List)list, (Entity)null, true);
        if (!list.isEmpty() && !(list1 = this.field_145850_b.func_72839_b((Entity)null, this.getMovementArea(axisalignedbb = this.moveByPositionAndProgress(this.func_191515_a(list)), enumfacing, d0).func_111270_a(axisalignedbb))).isEmpty()) {
            boolean flag = this.pistonState.func_177230_c() == Blocks.field_180399_cE || this.pistonState.func_177230_c() == ModulePistons.HALF_SLIME && this.pistonState.func_177229_b((IProperty)BlockHalfSlime.FACING) == enumfacing;
            for (int i = 0; i < list1.size(); ++i) {
                AxisAlignedBB axisalignedbb2;
                AxisAlignedBB axisalignedbb1;
                Entity entity = (Entity)list1.get(i);
                if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
                if (flag) {
                    switch (enumfacing.func_176740_k()) {
                        case X: {
                            entity.field_70159_w = enumfacing.func_82601_c();
                            break;
                        }
                        case Y: {
                            entity.field_70181_x = enumfacing.func_96559_d();
                            break;
                        }
                        case Z: {
                            entity.field_70179_y = enumfacing.func_82599_e();
                        }
                    }
                }
                double d1 = 0.0;
                for (int j = 0; !(j >= list.size() || Registry.PATCH.intersectsWith(axisalignedbb1 = this.getMovementArea(this.moveByPositionAndProgress((AxisAlignedBB)list.get(j)), enumfacing, d0), axisalignedbb2 = entity.func_174813_aQ()) && (d1 = Math.max(d1, this.getMovement(axisalignedbb1, enumfacing, axisalignedbb2))) >= d0); ++j) {
                }
                if (!(d1 > 0.0)) continue;
                d1 = Math.min(d1, d0) + 0.01;
                MOVING_ENTITY.set(enumfacing);
                entity.func_70091_d(MoverType.PISTON, d1 * (double)enumfacing.func_82601_c(), d1 * (double)enumfacing.func_96559_d(), d1 * (double)enumfacing.func_82599_e());
                MOVING_ENTITY.set(null);
                if (this.extending || !this.shouldHeadBeRendered) continue;
                this.fixEntityWithinPistonBase(entity, enumfacing, d0);
            }
        }
    }

    private AxisAlignedBB func_191515_a(List<AxisAlignedBB> p_191515_1_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        for (AxisAlignedBB axisalignedbb : p_191515_1_) {
            d0 = Math.min(axisalignedbb.field_72340_a, d0);
            d1 = Math.min(axisalignedbb.field_72338_b, d1);
            d2 = Math.min(axisalignedbb.field_72339_c, d2);
            d3 = Math.max(axisalignedbb.field_72336_d, d3);
            d4 = Math.max(axisalignedbb.field_72337_e, d4);
            d5 = Math.max(axisalignedbb.field_72334_f, d5);
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    private double getMovement(AxisAlignedBB p_190612_1_, EnumFacing p_190612_2_, AxisAlignedBB p_190612_3_) {
        switch (p_190612_2_.func_176740_k()) {
            case X: {
                return TileEntityPistonFix.getDeltaX(p_190612_1_, p_190612_2_, p_190612_3_);
            }
            default: {
                return TileEntityPistonFix.getDeltaY(p_190612_1_, p_190612_2_, p_190612_3_);
            }
            case Z: 
        }
        return TileEntityPistonFix.getDeltaZ(p_190612_1_, p_190612_2_, p_190612_3_);
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB p_190607_1_) {
        double d0 = this.getExtendedProgress(this.progress);
        return p_190607_1_.func_72317_d((double)this.field_174879_c.func_177958_n() + d0 * (double)this.pistonFacing.func_82601_c(), (double)this.field_174879_c.func_177956_o() + d0 * (double)this.pistonFacing.func_96559_d(), (double)this.field_174879_c.func_177952_p() + d0 * (double)this.pistonFacing.func_82599_e());
    }

    private AxisAlignedBB getMovementArea(AxisAlignedBB aabb, EnumFacing facing, double p_190610_3_) {
        double d0 = p_190610_3_ * (double)facing.func_176743_c().func_179524_a();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        switch (facing) {
            case WEST: {
                return new AxisAlignedBB(aabb.field_72340_a + d1, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72340_a + d2, aabb.field_72337_e, aabb.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(aabb.field_72336_d + d1, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d + d2, aabb.field_72337_e, aabb.field_72334_f);
            }
            case DOWN: {
                return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b + d1, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72338_b + d2, aabb.field_72334_f);
            }
            default: {
                return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72337_e + d1, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e + d2, aabb.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c + d1, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c + d2);
            }
            case SOUTH: 
        }
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f + d1, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f + d2);
    }

    private void fixEntityWithinPistonBase(Entity entity, EnumFacing facing, double p_190605_3_) {
        double d1;
        EnumFacing enumfacing;
        double d0;
        AxisAlignedBB axisalignedbb1;
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        if (Registry.PATCH.intersectsWith(axisalignedbb, axisalignedbb1 = Block.field_185505_j.func_186670_a(this.field_174879_c)) && Math.abs((d0 = this.getMovement(axisalignedbb1, enumfacing = facing.func_176734_d(), axisalignedbb) + 0.01) - (d1 = this.getMovement(axisalignedbb1, enumfacing, axisalignedbb.func_191500_a(axisalignedbb1)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, p_190605_3_) + 0.01;
            MOVING_ENTITY.set(facing);
            entity.func_70091_d(MoverType.PISTON, d0 * (double)enumfacing.func_82601_c(), d0 * (double)enumfacing.func_96559_d(), d0 * (double)enumfacing.func_82599_e());
            MOVING_ENTITY.set(null);
        }
    }

    private static double getDeltaX(AxisAlignedBB p_190611_0_, EnumFacing p_190611_1_, AxisAlignedBB p_190611_2_) {
        return p_190611_1_.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? p_190611_0_.field_72336_d - p_190611_2_.field_72340_a : p_190611_2_.field_72336_d - p_190611_0_.field_72340_a;
    }

    private static double getDeltaY(AxisAlignedBB p_190608_0_, EnumFacing p_190608_1_, AxisAlignedBB p_190608_2_) {
        return p_190608_1_.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? p_190608_0_.field_72337_e - p_190608_2_.field_72338_b : p_190608_2_.field_72337_e - p_190608_0_.field_72338_b;
    }

    private static double getDeltaZ(AxisAlignedBB p_190604_0_, EnumFacing p_190604_1_, AxisAlignedBB p_190604_2_) {
        return p_190604_1_.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? p_190604_0_.field_72334_f - p_190604_2_.field_72339_c : p_190604_2_.field_72334_f - p_190604_0_.field_72339_c;
    }

    public void func_190609_a(World p_190609_1_, BlockPos p_190609_2_, AxisAlignedBB p_190609_3_, List<AxisAlignedBB> p_190609_4_, @Nullable Entity p_190609_5_) {
        if (!this.extending && this.shouldHeadBeRendered) {
            this.pistonState.func_177226_a((IProperty)BlockPistonBase.field_176320_b, (Comparable)Boolean.valueOf(true)).func_185908_a(p_190609_1_, p_190609_2_, p_190609_3_, p_190609_4_, p_190609_5_, false);
        }
        EnumFacing enumfacing = MOVING_ENTITY.get();
        if ((double)this.progress >= 1.0 || enumfacing != (this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d())) {
            int i = p_190609_4_.size();
            IBlockState iblockstate = this.func_145867_d() ? Blocks.field_150332_K.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)this.pistonFacing).func_177226_a((IProperty)BlockPistonExtension.field_176327_M, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 0.25f)) : this.pistonState;
            float f = this.getExtendedProgress(this.progress);
            double d0 = (float)this.pistonFacing.func_82601_c() * f;
            double d1 = (float)this.pistonFacing.func_96559_d() * f;
            double d2 = (float)this.pistonFacing.func_82599_e() * f;
            iblockstate.func_185908_a(p_190609_1_, p_190609_2_, p_190609_3_.func_72317_d(-d0, -d1, -d2), p_190609_4_, p_190609_5_, true);
            for (int j = i; j < p_190609_4_.size(); ++j) {
                p_190609_4_.set(j, p_190609_4_.get(j).func_72317_d(d0, d1, d2));
            }
        }
    }
}

