/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons.BlockPistonBaseFix;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class BlockPistonStructureHelperFix
extends BlockPistonStructureHelper {
    private final World world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final EnumFacing moveDirection;
    private final EnumFacing pistonFacing;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private HashMap<Integer, ArrayList<BlockPos>> chestList = new HashMap();

    public BlockPistonStructureHelperFix(World worldIn, BlockPos posIn, EnumFacing pistonFacing, boolean extending) {
        super(worldIn, posIn, pistonFacing, extending);
        this.world = worldIn;
        this.pistonPos = posIn;
        this.pistonFacing = pistonFacing;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = posIn.func_177972_a(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.func_176734_d();
            this.blockToMove = posIn.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean func_177253_a() {
        this.toMove.clear();
        this.toDestroy.clear();
        IBlockState state = this.world.func_180495_p(this.blockToMove);
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        TileEntity tileEntity = null;
        if (state.func_177230_c().hasTileEntity(state)) {
            if (!ModulePistons.push_te) {
                this.removeChests();
                return false;
            }
            tileEntity = this.world.func_175625_s(this.blockToMove);
        }
        if (!BlockPistonBaseFix.canPush(state, this.world, this.blockToMove, this.moveDirection, false, this.pistonFacing)) {
            if (movable.isDestroyedOnMove(this.world, state, tileEntity, this.blockToMove)) {
                this.toDestroy.add(this.blockToMove);
                return this.canMoveChests();
            }
            this.removeChests();
            return false;
        }
        if (movable.isBlockDestroyer(this.world, state, tileEntity, this.blockToMove, this.blockToMove.func_177972_a(this.moveDirection), this.moveDirection.func_176734_d())) {
            if (BlockPistonBaseFix.canPush(this.world.func_180495_p(this.blockToMove.func_177972_a(this.moveDirection)), this.world, this.blockToMove.func_177972_a(this.moveDirection), this.moveDirection, true, this.moveDirection)) {
                this.toMove.add(this.blockToMove);
                this.toDestroy.add(this.blockToMove.func_177972_a(this.moveDirection));
                return this.canMoveChests();
            }
            this.removeChests();
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.pistonFacing)) {
            this.removeChests();
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos blockpos = this.toMove.get(i);
            IBlockState state2 = this.world.func_180495_p(blockpos);
            IMovable movable2 = MovableRegistry.getIMovable(state2.func_177230_c());
            TileEntity tileEntity2 = null;
            if (state2.func_177230_c().hasTileEntity(state2)) {
                tileEntity2 = this.world.func_175625_s(blockpos);
            }
            if (!movable2.isSticky(state2, tileEntity2) || this.addBranchingBlocks(this.world, state2, tileEntity2, movable2, blockpos)) continue;
            this.removeChests();
            return false;
        }
        return this.canMoveChests();
    }

    private boolean addBlockLine(BlockPos origin, EnumFacing side) {
        IBlockState iblockstate = this.world.func_180495_p(origin);
        Block block = iblockstate.func_177230_c();
        IMovable movable = MovableRegistry.getIMovable(block);
        TileEntity tileEntity = null;
        if (block.hasTileEntity(iblockstate)) {
            if (!ModulePistons.push_te) {
                this.removeChests();
                return false;
            }
            tileEntity = this.world.func_175625_s(origin);
        }
        if (movable.isBlockChest(iblockstate, tileEntity)) {
            this.addChest(origin, iblockstate);
        }
        if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.world, origin)) {
            return this.canMoveChests();
        }
        if (movable.isDestroyedOnMove(this.world, iblockstate, tileEntity, origin)) {
            this.toDestroy.add(origin);
            return this.canMoveChests();
        }
        if (!BlockPistonBaseFix.canPush(iblockstate, this.world, origin, this.moveDirection, false, side)) {
            return this.canMoveChests();
        }
        if (origin.equals((Object)this.pistonPos)) {
            return this.canMoveChests();
        }
        if (this.toMove.contains(origin)) {
            return this.canMoveChests();
        }
        int i = 1;
        if (i + this.toMove.size() > ModulePistons.push_limit) {
            this.removeChests();
            return false;
        }
        BlockPos blockpos = origin;
        while (movable.isSticky(iblockstate, tileEntity) && movable.isSideSticky(this.world, iblockstate, tileEntity, blockpos, this.moveDirection.func_176734_d())) {
            blockpos = origin.func_177967_a(this.moveDirection.func_176734_d(), i);
            iblockstate = this.world.func_180495_p(blockpos);
            block = iblockstate.func_177230_c();
            movable = MovableRegistry.getIMovable(block);
            if (block.hasTileEntity(iblockstate)) {
                if (!ModulePistons.push_te) {
                    this.removeChests();
                    return false;
                }
                tileEntity = this.world.func_175625_s(blockpos);
            } else {
                tileEntity = null;
            }
            if (!movable.willSideStick(this.world, iblockstate, tileEntity, blockpos, this.moveDirection) || blockpos.equals((Object)this.pistonPos)) break;
            if (++i + this.toMove.size() <= ModulePistons.push_limit) continue;
            this.removeChests();
            return false;
        }
        int i1 = 0;
        for (int j = i - 1; j >= 0; --j) {
            this.toMove.add(origin.func_177967_a(this.moveDirection.func_176734_d(), j));
            ++i1;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int k;
            if ((k = this.toMove.indexOf(blockpos1 = origin.func_177967_a(this.moveDirection, j1))) > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos blockpos2 = this.toMove.get(l);
                    IBlockState state2 = this.world.func_180495_p(blockpos2);
                    IMovable movable2 = MovableRegistry.getIMovable(state2.func_177230_c());
                    TileEntity tileEntity2 = null;
                    if (state2.func_177230_c().hasTileEntity(state2)) {
                        if (!ModulePistons.push_te) {
                            this.removeChests();
                            return false;
                        }
                        tileEntity2 = this.world.func_175625_s(blockpos2);
                    }
                    if (!movable2.isSticky(state2, tileEntity2) || this.addBranchingBlocks(this.world, state2, tileEntity2, movable2, blockpos2)) continue;
                    this.removeChests();
                    return false;
                }
                return this.canMoveChests();
            }
            iblockstate = this.world.func_180495_p(blockpos1);
            block = iblockstate.func_177230_c();
            movable = MovableRegistry.getIMovable(block);
            if (block.hasTileEntity(iblockstate)) {
                if (!ModulePistons.push_te) {
                    this.removeChests();
                    return false;
                }
                tileEntity = this.world.func_175625_s(blockpos1);
            } else {
                tileEntity = null;
            }
            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.world, blockpos1)) {
                return this.canMoveChests();
            }
            if (!BlockPistonBaseFix.canPush(iblockstate, this.world, blockpos1, this.moveDirection, true, this.moveDirection) || blockpos1.equals((Object)this.pistonPos)) {
                this.removeChests();
                return false;
            }
            if (movable.isDestroyedOnMove(this.world, iblockstate, tileEntity, blockpos1)) {
                this.toDestroy.add(blockpos1);
                return this.canMoveChests();
            }
            if (movable.isBlockChest(iblockstate, tileEntity)) {
                this.addChest(blockpos1, iblockstate);
            }
            if (this.toMove.size() >= ModulePistons.push_limit) {
                this.removeChests();
                return false;
            }
            this.toMove.add(blockpos1);
            ++i1;
            ++j1;
        }
    }

    private void reorderListAtCollision(int p_177255_1_, int p_177255_2_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, p_177255_2_));
        list1.addAll(this.toMove.subList(this.toMove.size() - p_177255_1_, this.toMove.size()));
        list2.addAll(this.toMove.subList(p_177255_2_, this.toMove.size() - p_177255_1_));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private boolean addBranchingBlocks(World world, IBlockState state, TileEntity tileEntity, IMovable movable, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing.func_176740_k() == this.moveDirection.func_176740_k()) continue;
            IBlockState other = world.func_180495_p(pos.func_177972_a(enumfacing));
            IMovable other_movable = MovableRegistry.getIMovable(other.func_177230_c());
            TileEntity other_tileEntity = null;
            if (other.func_177230_c().hasTileEntity(other)) {
                other_tileEntity = world.func_175625_s(pos.func_177972_a(enumfacing));
            }
            if (!movable.isSideSticky(world, state, tileEntity, pos, enumfacing) || !other_movable.willSideStick(world, other, other_tileEntity, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()) || this.addBlockLine(pos.func_177972_a(enumfacing), enumfacing)) continue;
            return false;
        }
        return true;
    }

    private void addToDestroyList(World world) {
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i).func_177972_a(EnumFacing.UP);
            IBlockState state = world.func_180495_p(pos);
            IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
            TileEntity tileEntity = null;
            if (state.func_177230_c().hasTileEntity(state)) {
                tileEntity = world.func_175625_s(pos);
            }
            if (this.toDestroy.contains(pos) || !movable.isDestroyedOnMove(world, state, tileEntity, pos) || movable.getAttachedSide(world, state, tileEntity, pos) != EnumFacing.DOWN) continue;
            this.toDestroy.add(pos);
        }
    }

    public List<BlockPos> func_177254_c() {
        return this.toMove;
    }

    public List<BlockPos> func_177252_d() {
        return this.toDestroy;
    }

    public void addChest(BlockPos pos, IBlockState state) {
        int type;
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        TileEntity tileEntity = null;
        if (state.func_177230_c().hasTileEntity(state)) {
            tileEntity = this.world.func_175625_s(pos);
        }
        if ((type = TileEntityHelper.getChestType(state, tileEntity)) != -1) {
            if (!this.chestList.containsKey(type)) {
                this.chestList.put(type, new ArrayList());
            }
            ArrayList<BlockPos> list = this.chestList.get(type);
            list.add(pos);
            TileEntityHelper.add_chest(this.world, pos.func_177972_a(this.moveDirection), this.moveDirection);
        }
    }

    public void removeChests() {
        for (ArrayList<BlockPos> list : this.chestList.values()) {
            TileEntityHelper.remove_chestList(this.world, list, this.moveDirection);
        }
    }

    public boolean canMoveChests() {
        this.addToDestroyList(this.world);
        return true;
    }

    public List<BlockPos> getChestUpdateList() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i);
            IBlockState state = this.world.func_180495_p(pos);
            Object tileEntity = null;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                BlockPos p = pos.func_177972_a(dir);
                if (list.contains(p)) continue;
                list.add(p);
            }
        }
        return list;
    }
}

