/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedDispensers;

import net.minecraft.block.Block;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import sandro.Core.PatchLibrary.Config.ConfigHandler;
import sandro.Core.PatchLibrary.Module.IModule;
import sandro.Core.PatchRegistry.Registry;
import sandro.Core.PatchRegistry.Remapper;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseAnimalFood;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseCake;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseCauldron;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseGravityBlock;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseIPlantable;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseItemFrame;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseJukebox;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseMilk;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseShears;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.Behaviours.DispenseSponge;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.BlockDispenserFix;

public class ModuleDispensers
implements IModule {
    public static boolean isEnabled;
    public static boolean canPlantSeeds;
    public static boolean canPlaceCake;
    public static boolean canFillCauldron;
    public static boolean canUseItemFrames;
    public static boolean canUseJukeBoxes;
    public static boolean canMilkCows;
    public static boolean canUseShears;
    public static boolean canFeedAnimals;
    public static boolean canPlaceSponge;
    public static boolean canPlaceBlockInMinecarts;
    public static boolean fixMinecartGlitch;
    public static boolean canPlaceGravityBlocks;
    public static String[] gravityBlocks;
    public static BlockDispenserFix DISPENSER;

    @Override
    public boolean isEnabled() {
        return isEnabled || Registry.MODULE.isEnabled("PistonFix");
    }

    @Override
    public String getName() {
        return "ImprovedDispensers";
    }

    @Override
    public void registerConfig(ConfigHandler config) {
        config.addCategory("dispenser", "Dispenser Module");
        isEnabled = config.getBool("enableDispenserFix", true, "Enable Dispenser Subsutition (This will be forced enabled if PistonFix is enabled)");
        config.addCategory("dispenser.settings", "Dispenser Settings");
        canPlantSeeds = config.getBool("canPlantSeeds", true, "Allow Dispensers to plant Seeds and Saprolings.");
        canPlaceCake = config.getBool("canPlaceCake", true, "Allow Dispensers to place Cake.");
        canFillCauldron = config.getBool("canFillCauldron", true, "Allow Dispensers to fill and empty Cauldrons with buckets and bottles.");
        canUseItemFrames = config.getBool("canUseItemFrames", true, "Allow Dispensers to place and remove items from Item Frames.");
        canUseJukeBoxes = config.getBool("canUseJukeBoxes", true, "Allow Dispensers to place and remove records from Juke Bokes.");
        canMilkCows = config.getBool("canMilkCows", true, "Allow Dispensers to Milk Cows and Mooshrooms");
        canUseShears = config.getBool("canUseShears", true, "Allow Dispensers to Shear Sheep, Mooshrooms, ect.");
        canFeedAnimals = config.getBool("canFeedAnimals", true, "Allow Dispensers to Feed Animals(Except Horses) for breeding.");
        canPlaceSponge = config.getBool("canPlaceSponge", true, "Allow Dispensers to place and pickup Sponges.");
        canPlaceBlockInMinecarts = config.getBool("canPlaceBlockInMinecarts", true, "Allow Dispensers to place compatable blocks into empty minecarts. (Only works for vanella minecarts)");
        fixMinecartGlitch = config.getBool("fixMinecartGlitch", true, "Fix Vanella Bug allowing Dispensers to glitch multiple minecarts ontop of each other.");
        canPlaceGravityBlocks = config.getBool("canPlaceGravityBlocks", true, "Allow Dispensers to place gravity affected blocks (sand, gravel, anvils, ect.)");
        gravityBlocks = config.getStringArray("gravityBlocks", new String[]{Blocks.field_150354_m.getRegistryName().toString(), Blocks.field_150351_n.getRegistryName().toString(), Blocks.field_192444_dS.getRegistryName().toString(), Blocks.field_150467_bQ.getRegistryName().toString()}, "List of gravity affected blocks.");
    }

    @Override
    public void registerBlocks() {
        DISPENSER = new BlockDispenserFix();
        Registry.GAME.subBlock(Blocks.field_150367_z, (Block)DISPENSER);
    }

    @Override
    public void Init() {
        if (isEnabled) {
            if (canPlaceCake) {
                Registry.DISPENSER.addBehaviour(Items.field_151105_aU, (IBehaviorDispenseItem)new DispenseCake());
            }
            if (canUseItemFrames) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseItemFrame());
            }
            if (canFillCauldron) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseCauldron());
            }
            if (canUseJukeBoxes) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseJukebox());
            }
            if (canPlantSeeds) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseIPlantable());
            }
            if (canMilkCows) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseMilk());
            }
            if (canUseShears) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseShears());
            }
            if (canFeedAnimals) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseAnimalFood());
            }
            if (canPlaceSponge) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseSponge());
            }
            if (canPlaceGravityBlocks) {
                DISPENSER.registerDispenserBehaviourHook(new DispenseGravityBlock());
            }
        }
    }

    @Override
    public void registerRemap() {
        Remapper.remapBlock("sandro:dispenser", (Block)DISPENSER);
    }

    public static boolean isGravityBlock(Item item) {
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            return ModuleDispensers.isGravityBlock(itemBlock.func_179223_d());
        }
        return false;
    }

    public static boolean isGravityBlock(Block block) {
        String n = block.getRegistryName().toString();
        for (int i = 0; i < gravityBlocks.length; ++i) {
            if (!n.equals(gravityBlocks[i])) continue;
            return true;
        }
        return false;
    }
}

