/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import sandro.RedstonePlusPlus.API.Movable.IMovableClient;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableChestClient;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableClientDefault;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableHopperClient;

public class MovableClientRegistry {
    private static HashMap<Block, IMovableClient> movableRegistry = new HashMap();
    private static final IMovableClient DEFAULT = new MovableClientDefault();

    public static void registerIMovable(IMovableClient movable) {
        List<Block> list = movable.getBlockList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MovableClientRegistry.registerIMovable(list.get(i), movable);
        }
    }

    public static void registerIMovable(Block block, IMovableClient movable) {
        if (!movableRegistry.containsKey(block)) {
            movableRegistry.put(block, movable);
        }
    }

    public static IMovableClient getIMovable(Block block) {
        if (movableRegistry.containsKey(block)) {
            return movableRegistry.get(block);
        }
        return DEFAULT;
    }

    public static void registerStandardIMovables() {
        MovableClientRegistry.registerIMovable(new MovableChestClient());
        MovableClientRegistry.registerIMovable(new MovableHopperClient());
    }
}

