/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable.Implementations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;

public class MovableChest
implements IMovable {
    private Block QUARK_CHEST = null;
    private Block QUARK_CHEST_TRAP = null;
    private Block IRON_CHEST = null;

    @Override
    public List<Block> getBlockList() {
        Block block;
        ArrayList<Block> list = new ArrayList<Block>();
        list.add((Block)Blocks.field_150486_ae);
        list.add(Blocks.field_150447_bR);
        list.add(Blocks.field_150477_bB);
        if (Registry.INFO.isModInstalled("quark")) {
            block = Registry.PATCH.getBlockFromName("quark:custom_chest");
            if (block != null) {
                this.QUARK_CHEST = block;
                list.add(block);
            }
            if ((block = Registry.PATCH.getBlockFromName("quark:custom_chest_trap")) != null) {
                this.QUARK_CHEST_TRAP = block;
                list.add(block);
            }
        }
        if (Registry.INFO.isModInstalled("ironchest") && (block = Registry.PATCH.getBlockFromName("ironchest:iron_chest")) != null) {
            this.IRON_CHEST = block;
            list.add(block);
        }
        return list;
    }

    @Override
    public boolean canMove(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        if (this.IRON_CHEST == null) {
            return true;
        }
        return state.func_177230_c() != this.IRON_CHEST || this.IRON_CHEST.func_176201_c(state) != 6;
    }

    @Override
    public boolean isDestroyedOnMove(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        return false;
    }

    @Override
    public boolean willSideStick(World world, IBlockState state, TileEntity tileEntity, BlockPos pos, EnumFacing side) {
        return this.canMove(world, state, tileEntity, pos);
    }

    @Override
    public boolean isBlockChest(IBlockState state, TileEntity tileEntity) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == this.QUARK_CHEST || block == this.QUARK_CHEST_TRAP;
    }

    @Override
    public int getChestType(IBlockState state, TileEntity tileEntity) {
        NBTTagCompound tag;
        Block block = state.func_177230_c();
        if (block == Blocks.field_150486_ae) {
            return 0;
        }
        if (block == Blocks.field_150447_bR) {
            return 1;
        }
        if (block == this.QUARK_CHEST) {
            NBTTagCompound tag2 = tileEntity.serializeNBT();
            if (tag2.func_74764_b("type")) {
                String type = tag2.func_74779_i("type");
                if (type.equals("spruce")) {
                    return 2;
                }
                if (type.equals("birch")) {
                    return 3;
                }
                if (type.equals("jungle")) {
                    return 4;
                }
                if (type.equals("acacia")) {
                    return 5;
                }
                if (type.equals("dark_oak")) {
                    return 6;
                }
            }
        } else if (block == this.QUARK_CHEST_TRAP && (tag = tileEntity.serializeNBT()).func_74764_b("type")) {
            String type = tag.func_74779_i("type");
            if (type.equals("spruce")) {
                return 7;
            }
            if (type.equals("birch")) {
                return 8;
            }
            if (type.equals("jungle")) {
                return 9;
            }
            if (type.equals("acacia")) {
                return 10;
            }
            if (type.equals("dark_oak")) {
                return 11;
            }
        }
        return -1;
    }

    @Override
    public void postMove(World world, IBlockState state, TileEntity tileEntity, NBTTagCompound compound, BlockPos pos) {
        if (!world.field_72995_K) {
            if (this.canChestStay(world, state, tileEntity, pos)) {
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    MovableChest other_movableChest;
                    BlockPos other_pos = pos.func_177972_a(side);
                    IBlockState other_state = world.func_180495_p(other_pos);
                    Block other_block = other_state.func_177230_c();
                    IMovable other_movable = MovableRegistry.getIMovable(other_block);
                    TileEntity other_tileEntity = null;
                    if (other_block.hasTileEntity(other_state)) {
                        other_tileEntity = world.func_175625_s(other_pos);
                    }
                    if (!(other_movable instanceof MovableChest) || (other_movableChest = (MovableChest)other_movable).canChestStay(world, other_state, other_tileEntity, other_pos)) continue;
                    other_block.func_176226_b(world, other_pos, other_state, 0);
                    world.func_175698_g(other_pos);
                }
            } else {
                state.func_177230_c().func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
        }
    }

    public boolean canChestStay(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        int type = this.getChestType(state, tileEntity);
        if (type != -1) {
            int cnt = 0;
            for (EnumFacing side : EnumFacing.field_176754_o) {
                BlockPos other_pos = pos.func_177972_a(side);
                IBlockState other_state = world.func_180495_p(other_pos);
                Block other_block = other_state.func_177230_c();
                IMovable other_movable = MovableRegistry.getIMovable(other_block);
                TileEntity other_tileEntity = null;
                if (other_block.hasTileEntity(other_state)) {
                    other_tileEntity = world.func_175625_s(other_pos);
                }
                if (!other_movable.isBlockChest(other_state, other_tileEntity) || other_movable.getChestType(other_state, other_tileEntity) != type) continue;
                ++cnt;
            }
            if (cnt >= 2) {
                return false;
            }
        }
        return true;
    }

    public void destroyChest(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        Block block = state.func_177230_c();
    }
}

