/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public interface IMovable {
    default public List<Block> getBlockList() {
        return null;
    }

    default public boolean canMove(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        return Registry.PATCH.pistonCanPush(state) && state.func_185887_b(world, pos) >= 0.0f;
    }

    default public boolean isDestroyedOnMove(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        return Registry.PATCH.pistonCanDestroy(state) || state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
    }

    default public EnumFacing getAttachedSide(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        return null;
    }

    default public float getWeight(World world, IBlockState state, TileEntity tileEntity, BlockPos pos) {
        return 1.0f;
    }

    default public boolean willSideStick(World world, IBlockState state, TileEntity tileEntity, BlockPos pos, EnumFacing side) {
        return Registry.PATCH.pistonCanStick(state);
    }

    default public boolean canPush(World world, IBlockState state, TileEntity tileEntity, BlockPos fromPos, BlockPos toPos, EnumFacing direction, EnumFacing side) {
        return true;
    }

    default public boolean canRotate(World world, IBlockState state, TileEntity tileEntity, BlockPos fromPos, BlockPos toPos, EnumFacing.Axis axis, EnumRotate direction, EnumFacing side) {
        return !(state.func_177227_a().contains(BlockHorizontal.field_185512_D) && axis != EnumFacing.Axis.Y || Registry.PATCH.pistonCanDestroy(state) || state.func_177230_c() instanceof BlockRailBase && axis != EnumFacing.Axis.Y);
    }

    default public boolean isSticky(IBlockState state, TileEntity tileEntity) {
        return false;
    }

    default public boolean isSideSticky(World world, IBlockState state, TileEntity tileEntity, BlockPos pos, EnumFacing side) {
        return false;
    }

    default public boolean isBlockDestroyer(World world, IBlockState state, TileEntity tileEntity, BlockPos fromPos, BlockPos toPos, EnumFacing side) {
        return false;
    }

    default public boolean isBlockChest(IBlockState state, TileEntity tileEntity) {
        return false;
    }

    default public int getChestType(IBlockState state, TileEntity tileEntity) {
        return -1;
    }

    default public void preMove(World world, IBlockState state, TileEntity tileEntity, NBTTagCompound compound, BlockPos fromPos, BlockPos toPos) {
        if (tileEntity != null) {
            if (tileEntity instanceof ISidedInventory) {
                ISidedInventory inventory = (ISidedInventory)tileEntity;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            tileEntity.func_145839_a(TileEntityHelper.get_emptyTileEntity(compound));
        }
    }

    default public void move(World world, IBlockState state, TileEntity tileEntity, NBTTagCompound compound, BlockPos pos) {
    }

    default public void postMove(World world, IBlockState state, TileEntity tileEntity, NBTTagCompound compound, BlockPos pos) {
    }

    default public IBlockState rotate(IBlockState state, NBTTagCompound compound, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction) {
        if (direction == EnumRotate.counterclockwise) {
            state = this.rotate(state, compound, pos, axis, EnumRotate.clockwise);
            state = this.rotate(state, compound, pos, axis, EnumRotate.clockwise);
        }
        if (state.func_177227_a().contains(BlockDirectional.field_176387_N)) {
            return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176732_a(axis));
        }
        if (state.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D) && axis.func_176720_b()) {
            return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176746_e());
        }
        if (state.func_177228_b().containsKey((Object)BlockRail.field_176565_b) && axis.func_176720_b()) {
            switch ((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)BlockRail.field_176565_b)) {
                case ASCENDING_EAST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                }
                case ASCENDING_NORTH: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                }
                case ASCENDING_SOUTH: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                }
                case ASCENDING_WEST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                }
                case EAST_WEST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                }
                case NORTH_EAST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                }
                case NORTH_SOUTH: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                }
                case NORTH_WEST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                }
                case SOUTH_EAST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                }
                case SOUTH_WEST: {
                    return state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                }
            }
            return state;
        }
        return state;
    }
}

