/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary;

import net.minecraftforge.fml.common.Loader;

public class Version {
    public final int major;
    public final int minor;
    public final int patch;

    public Version() {
        this(Loader.instance().getMCVersionString());
    }

    public Version(String version) {
        String[] ver = this.renderVersionSafe(version).split("\\.");
        this.major = Integer.parseInt(ver[0]);
        this.minor = Integer.parseInt(ver[1]);
        this.patch = ver.length > 2 ? Integer.parseInt(ver[2]) : 0;
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public String getVersion() {
        String version = this.getVersionNoPatch();
        if (this.patch > 0) {
            version = version + "." + this.patch;
        }
        return version;
    }

    public String getVersionNoPatch() {
        return "MC" + this.major + "." + this.minor;
    }

    public Version getPreviousVersion() {
        if (this.patch <= 0) {
            return null;
        }
        return new Version(this.major, this.minor, this.patch - 1);
    }

    public boolean equals(String version) {
        return this.equals(new Version(version));
    }

    public boolean equals(Version version) {
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    public boolean equivalent(String version) {
        return this.equivalent(new Version(version));
    }

    public boolean equivalent(Version version) {
        return this.major == version.major && this.minor == version.minor;
    }

    public boolean isNewer(String version) {
        return this.isNewer(new Version(version));
    }

    public boolean isNewer(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major == version.major) {
            if (this.minor > version.minor) {
                return true;
            }
            if (this.minor == version.minor && this.patch > version.patch) {
                return true;
            }
        }
        return false;
    }

    public boolean isAtLeast(String version) {
        return this.isAtLeast(new Version(version));
    }

    public boolean isAtLeast(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major == version.major) {
            if (this.minor > version.minor) {
                return true;
            }
            if (this.minor == version.minor && this.patch >= version.patch) {
                return true;
            }
        }
        return false;
    }

    public boolean isOlder(String version) {
        return this.isOlder(new Version(version));
    }

    public boolean isOlder(Version version) {
        if (this.major < version.major) {
            return true;
        }
        if (this.major == version.major) {
            if (this.minor < version.minor) {
                return true;
            }
            if (this.minor == version.minor && this.patch < version.patch) {
                return true;
            }
        }
        return false;
    }

    private String renderVersionSafe(String version) {
        String v = "";
        block4: for (int i = 0; i < version.length(); ++i) {
            switch (version.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    v = v + version.charAt(i);
                    continue block4;
                }
                case '.': 
                case '_': {
                    v = v + '.';
                }
            }
        }
        return v;
    }
}

