/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import sandro.Core.PatchLibrary.Version;
import sandro.Core.PatchRegistry.Registry;

public class PatchLoader {
    public static String getPatchName(String className) {
        return "sandro." + className;
    }

    public static String getPatchName(String dir, String className) {
        return PatchLoader.getPatchName(dir + "." + PatchLoader.getMCVersion() + "." + className);
    }

    public static Object getPatch(String className) {
        Object obj = null;
        try {
            obj = Class.forName("sandro." + className).newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return obj;
    }

    public static Object getPatch(String dir, String className) {
        for (Version version = new Version(); version != null; version = version.getPreviousVersion()) {
            Object obj = PatchLoader.getPatch(dir + "." + PatchLoader.getMCVersion(version) + "." + className);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Class getPatchClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("sandro." + className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static Class getPatchClass(String dir, String className) {
        for (Version version = new Version(); version != null; version = version.getPreviousVersion()) {
            Class clazz = PatchLoader.getPatchClass(dir + "." + PatchLoader.getMCVersion(version) + "." + className);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static String getMCVersion() {
        return PatchLoader.getMCVersion(new Version());
    }

    public static String getMCVersion(Version version) {
        return version.getVersion().replace(".", "_");
    }

    public static Object getPrivateField(Object obj, String field) {
        try {
            Field f = obj.getClass().getDeclaredField(field);
            f.setAccessible(true);
            try {
                return f.get(obj);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setPrivateField(Object obj, String field, Object value) {
        PatchLoader.setPrivateField(obj, obj.getClass(), field, value);
    }

    public static void setPrivateField(Object obj, Class clazz, String field, Object value) {
        try {
            Field f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            try {
                modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            try {
                f.set(obj, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public static boolean fieldExists(Object obj, String field) {
        Class<?> objectClass = obj.getClass();
        for (Field f : objectClass.getFields()) {
            if (!f.getName().equals(field)) continue;
            return true;
        }
        return false;
    }

    public static Method getPrivateMethod(Object obj, String method, Class<?> ... parameterTypes) {
        Method classMethod = null;
        Class<?> objectClass = obj.getClass();
        try {
            classMethod = objectClass.getDeclaredMethod(method, parameterTypes);
            classMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return classMethod;
    }

    public static Object callPrivateMethod(Object obj, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(obj, parameters);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Object> getAnnotation(Class annotationClass) {
        Set asmDatas = Registry.PATCH.getASMData().getAll(annotationClass.getCanonicalName());
        ArrayList<Object> instances = new ArrayList<Object>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Object instance = asmClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return instances;
    }
}

