/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary.Module;

import java.util.ArrayList;
import sandro.Core.PatchLibrary.Config.ConfigHandler;
import sandro.Core.PatchLibrary.Config.ModuleConfigHandler;
import sandro.Core.PatchLibrary.Module.IModule;
import sandro.Core.PatchLibrary.Module.IModuleLoader;
import sandro.Core.PatchRegistry.Registry;

public class ModuleLoader
implements IModuleLoader {
    private final ArrayList<String> modIds = new ArrayList();
    private final ArrayList<String> enabledModIds = new ArrayList();

    @Override
    public void registerModules() {
    }

    @Override
    public void registerModule(IModule module) {
        modules.add(module);
        this.modIds.add(Registry.PATCH.getModID());
    }

    @Override
    public void handleConfig(ConfigHandler config) {
        modules.forEach(module -> module.registerConfig(config));
        for (int i = 0; i < modules.size(); ++i) {
            if (!((IModule)modules.get(i)).isEnabled()) continue;
            enabledModules.add(modules.get(i));
            this.enabledModIds.add(this.modIds.get(i));
        }
    }

    @Override
    public void handleRegistry() {
        int i;
        for (i = 0; i < enabledModules.size(); ++i) {
            Registry.PATCH.setModID(this.enabledModIds.get(i));
            ((IModule)enabledModules.get(i)).registerBlocks();
        }
        for (i = 0; i < enabledModules.size(); ++i) {
            Registry.PATCH.setModID(this.enabledModIds.get(i));
            ((IModule)enabledModules.get(i)).registerItems();
        }
        for (i = 0; i < enabledModules.size(); ++i) {
            Registry.PATCH.setModID(this.enabledModIds.get(i));
            ((IModule)enabledModules.get(i)).registerEntities();
        }
        Registry.PATCH.setModID(null);
    }

    public void registerConfig(ModuleConfigHandler config) {
        for (int i = 0; i < modules.size(); ++i) {
            config.addModule((IModule)modules.get(i));
        }
        config.loadFile();
        this.checkEnabled();
        Registry.MODULE.handleConstruct();
        Registry.MODULE.handleRegistry();
        Registry.MODULE.handleRemaps();
    }

    public void registerConfig(String filename, String version) {
        this.registerConfig(new ModuleConfigHandler(filename, version));
    }

    @Override
    public void checkEnabled() {
        for (int i = 0; i < modules.size(); ++i) {
            if (!((IModule)modules.get(i)).isEnabled()) continue;
            enabledModules.add(modules.get(i));
            this.enabledModIds.add(this.modIds.get(i));
        }
    }
}

