/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary.Module;

import java.util.ArrayList;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sandro.Core.PatchLibrary.Config.ConfigHandler;
import sandro.Core.PatchLibrary.Module.IModule;

public interface IModuleLoader {
    public static final ArrayList<IModule> modules = new ArrayList();
    public static final ArrayList<IModule> enabledModules = new ArrayList();

    public void registerModules();

    default public void registerModule(IModule module) {
        modules.add(module);
    }

    default public boolean isEnabled(String module) {
        for (int i = 0; i < enabledModules.size(); ++i) {
            if (!enabledModules.get(i).getName().equals(module)) continue;
            return true;
        }
        return false;
    }

    default public void handleConfig(ConfigHandler config) {
        modules.forEach(module -> module.registerConfig(config));
        this.checkEnabled();
    }

    default public void checkEnabled() {
        for (int i = 0; i < modules.size(); ++i) {
            if (!modules.get(i).isEnabled()) continue;
            enabledModules.add(modules.get(i));
        }
    }

    default public void handleRegistry() {
        enabledModules.forEach(module -> module.registerBlocks());
        enabledModules.forEach(module -> module.registerItems());
        enabledModules.forEach(module -> module.registerEntities());
    }

    default public void handleRecipes() {
        enabledModules.forEach(module -> module.registerRecipes());
    }

    default public void handleRemaps() {
        enabledModules.forEach(module -> module.registerRemap());
    }

    default public void handleConstruct() {
        enabledModules.forEach(module -> module.Construct());
    }

    default public void handlePreInit() {
        enabledModules.forEach(module -> module.preInit());
    }

    default public void handleInit() {
        enabledModules.forEach(module -> module.Init());
    }

    default public void handlePostInit() {
        enabledModules.forEach(module -> module.postInit());
    }

    @SideOnly(value=Side.CLIENT)
    default public void handleClientPreInit() {
        enabledModules.forEach(module -> module.clientPreInit());
    }

    @SideOnly(value=Side.CLIENT)
    default public void handleClientInit() {
        enabledModules.forEach(module -> module.clientInit());
    }

    @SideOnly(value=Side.CLIENT)
    default public void handleClientPostInit() {
        enabledModules.forEach(module -> module.clientPostInit());
    }

    default public void handleServerPreInit() {
        enabledModules.forEach(module -> module.serverPreInit());
    }

    default public void handleServerInit() {
        enabledModules.forEach(module -> module.serverInit());
    }

    default public void handleServerPostInit() {
        enabledModules.forEach(module -> module.serverPostInit());
    }

    default public void handleServerStart(FMLServerStartingEvent event) {
        enabledModules.forEach(module -> module.serverStart(event));
    }

    default public void handleServerStop() {
        enabledModules.forEach(module -> module.serverStop());
    }
}

