/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary.Entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sandro.Core.PatchLibrary.Entity.IEntityMessage;

public class EntityMessage
implements IMessage {
    private Entity entity;
    private ByteBuf buf;
    private UUID id;

    public EntityMessage() {
    }

    public <R extends Entity> EntityMessage(R entity) {
        this.entity = entity;
    }

    public void fromBytes(ByteBuf buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.id = new UUID(l1, l2);
        this.buf = buf.copy();
    }

    public void toBytes(ByteBuf buf) {
        IEntityMessage entity = (IEntityMessage)this.entity;
        buf.writeLong(this.entity.getPersistentID().getMostSignificantBits());
        buf.writeLong(this.entity.getPersistentID().getLeastSignificantBits());
        entity.writeData(buf);
    }

    public static class EntityMessageHandler
    implements IMessageHandler<EntityMessage, IMessage> {
        public IMessage onMessage(final EntityMessage message, final MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.handle(message, ctx);
                }
            });
            return null;
        }

        public void handle(EntityMessage message, MessageContext ctx) {
            for (Entity e : Minecraft.func_71410_x().field_71441_e.func_72910_y()) {
                if (!e.getPersistentID().equals(message.id)) continue;
                IEntityMessage entity = (IEntityMessage)e;
                entity.readData(message.buf);
            }
        }
    }
}

