/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary.ChunkLoading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import sandro.Core.Main;
import sandro.Core.PatchLibrary.ChunkLoading.IChunkLoadingCallback;

public class ChunkLoader
implements ForgeChunkManager.LoadingCallback {
    private static HashMap<Integer, IChunkLoadingCallback> callback_map = new HashMap();

    public static void registerCallback(IChunkLoadingCallback callback, int id) {
        callback_map.put(id, callback);
    }

    public static ForgeChunkManager.Ticket requestTicket(World world, ForgeChunkManager.Type type, int id) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)Main.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (ticket != null) {
            ticket.getModData().func_74768_a("CALLBACK_ID", id);
        }
        return ticket;
    }

    public static void releaseTicket(ForgeChunkManager.Ticket ticket) {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket, int x, int z) {
        ChunkLoader.forceChunk(ticket, new ChunkPos(x, z));
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket, ChunkPos pos) {
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
    }

    public static void unforceChunk(ForgeChunkManager.Ticket ticket, int x, int z) {
        ChunkLoader.unforceChunk(ticket, new ChunkPos(x, z));
    }

    public static void unforceChunk(ForgeChunkManager.Ticket ticket, ChunkPos pos) {
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
    }

    public static void reorderChunk(ForgeChunkManager.Ticket ticket, int x, int z) {
        ChunkLoader.reorderChunk(ticket, new ChunkPos(x, z));
    }

    public static void reorderChunk(ForgeChunkManager.Ticket ticket, ChunkPos pos) {
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
    }

    public static List<ChunkPos> getChunkList(ForgeChunkManager.Ticket ticket) {
        if (ticket == null) {
            return null;
        }
        NBTTagCompound data = ticket.getModData();
        if (!data.func_74764_b("CHUNK_KEY")) {
            return new ArrayList<ChunkPos>();
        }
        byte[] array = data.func_74770_j("CHUNK_LIST");
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        for (int i = 0; i < array.length; i += 8) {
            int x = (array[i] << 24) + (array[i + 1] << 16) + (array[i + 2] << 8) + array[i + 3];
            int z = (array[i + 4] << 24) + (array[i + 5] << 16) + (array[i + 6] << 8) + array[i + 7];
            list.add(new ChunkPos(x, z));
        }
        return list;
    }

    public static void setChunkList(ForgeChunkManager.Ticket ticket, List<ChunkPos> list) {
        if (ticket == null) {
            return;
        }
        NBTTagCompound data = ticket.getModData();
        byte[] array = new byte[list.size() * 8];
        for (int i = 0; i < list.size(); ++i) {
            ChunkPos pos = list.get(i);
            int x = pos.field_77276_a;
            int z = pos.field_77275_b;
            array[i] = (byte)(x >> 24);
            array[i + 1] = (byte)(x >> 16);
            array[i + 2] = (byte)(x >> 8);
            array[i + 3] = (byte)x;
            array[i + 4] = (byte)(z >> 24);
            array[i + 5] = (byte)(z >> 16);
            array[i + 6] = (byte)(z >> 8);
            array[i + 7] = (byte)z;
        }
        if (data.func_74764_b("CHUNK_LIST")) {
            data.func_82580_o("CHUNK_LIST");
        }
        data.func_74773_a("CHUNK_LIST", array);
    }

    public static void loadChunkList(ForgeChunkManager.Ticket ticket) {
        List<ChunkPos> list = ChunkLoader.getChunkList(ticket);
        for (int i = 0; i < list.size(); ++i) {
            ChunkLoader.forceChunk(ticket, list.get(i));
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (int i = 0; i < tickets.size(); ++i) {
            ForgeChunkManager.Ticket ticket = tickets.get(i);
            int id = ticket.getModData().func_74762_e("CALLBACK_ID");
            ChunkLoader.loadChunkList(ticket);
            callback_map.get(id).ticketLoaded(ticket);
        }
    }

    public static void registerChunnkLoader() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)Main.instance, (ForgeChunkManager.LoadingCallback)new ChunkLoader());
    }
}

