/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.Patch.MC1_12;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import sandro.Core.Patch.MC1_12.RegistryLibrary;
import sandro.Core.PatchRegistry.IRegistry.IGameRegistry;
import sandro.Core.PatchRegistry.Registry;

public class GameRegistry
implements IGameRegistry {
    @Override
    public void registerEventHandler(Object handler, int i) {
        if ((i & 1) != 0) {
            MinecraftForge.EVENT_BUS.register(handler);
        }
        if ((i & 2) != 0) {
            MinecraftForge.TERRAIN_GEN_BUS.register(handler);
        }
        if ((i & 4) != 0) {
            MinecraftForge.ORE_GEN_BUS.register(handler);
        }
    }

    @Override
    public void registerBlock(Block block) {
        ItemBlock itemBlock = new ItemBlock(block);
        this.registerBlock(block, itemBlock);
    }

    @Override
    public void registerBlock(Block block, ItemBlock itemBlock) {
        RegistryLibrary.registerBlock(block);
        Registry.PATCH.setRegistryName(itemBlock, block.getRegistryName().toString());
        this.registerItem((Item)itemBlock);
    }

    @Override
    public void registerItem(Item item) {
        RegistryLibrary.registerItem(item);
        RegistryLibrary.registerItemRenderer(item);
    }

    @Override
    public void registerEntity(String name, Class<? extends Entity> entityClass, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        RegistryLibrary.registerEntity(name, Registry.PATCH.getModID(), entityClass, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    @Override
    public void registerHalfSlab(BlockSlab half_slab, BlockSlab double_slab) {
        RegistryLibrary.registerBlock((Block)half_slab);
        ItemSlab itemSlab = new ItemSlab((Block)half_slab, half_slab, double_slab);
        Registry.PATCH.setRegistryName(itemSlab, half_slab.getRegistryName().toString());
        this.registerItem((Item)itemSlab);
        RegistryLibrary.registerBlock((Block)double_slab);
    }

    @Override
    public void subBlock(Block oldBlock, Block newBlock) {
        if (newBlock.func_149739_a().equals("tile.null")) {
            newBlock.func_149663_c(oldBlock.func_149739_a().substring(5));
        }
        Registry.PATCH.setRegistryName(newBlock, oldBlock.getRegistryName().toString());
        RegistryLibrary.registerBlock(newBlock);
    }

    @Override
    public void subItem(Item oldItem, Item newItem) {
        if (newItem.func_77658_a().equals("item.null")) {
            newItem.func_77655_b(oldItem.func_77658_a().substring(5));
        }
        Registry.PATCH.setRegistryName(newItem, oldItem.getRegistryName().toString());
        RegistryLibrary.registerItem(newItem);
    }

    @Override
    public void subEntity(String name, Class<? extends Entity> oldEntity, Class<? extends Entity> newEntity, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        this.registerEntity(name, newEntity, trackingRange, updateFrequency, sendsVelocityUpdates);
        RegistryLibrary.subEntityMap.put(oldEntity, newEntity);
    }

    @Override
    public void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String id) {
        net.minecraftforge.fml.common.registry.GameRegistry.registerTileEntity(tileEntityClass, (String)id);
    }

    @Override
    public void registerGuiHandler(IGuiHandler gui) {
        RegistryLibrary.registerGuiHandler(gui);
    }

    @Override
    public void registerCommand(FMLServerStartingEvent event, ICommand command) {
        event.registerServerCommand(command);
    }
}

