/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.jei;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.google.common.collect.Lists;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import mezz.jei.ingredients.Ingredients;
import net.minecraft.item.ItemStack;
import rocks.gameonthe.rockytweaks.RockyTweaks;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRecipe;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRecipeHandler;

@JEIPlugin
public class RockyTweaksJEIPlugin
implements IModPlugin {
    private IModRegistry registry;
    private List<IRecipeWrapper> recipeWrappers;

    public void register(@Nonnull IModRegistry modRegistry) {
        this.registry = modRegistry;
        this.recipeWrappers = this.getRecipeWrappers(AnvilRecipeHandler.getRecipes());
        this.registry.addRecipes(this.recipeWrappers, "minecraft.anvil");
        RockyTweaks.logger.info("Registered {} anvil recipes with JEI.", (Object)AnvilRecipeHandler.getRecipes().size());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeRegistry recipeRegistry = jeiRuntime.getRecipeRegistry();
        IRecipeCategory anvilRecipeCategory = recipeRegistry.getRecipeCategory("minecraft.anvil");
        if (anvilRecipeCategory == null) {
            return;
        }
        if (AnvilRecipeHandler.isRemoveAll()) {
            recipeRegistry.getRecipeWrappers(anvilRecipeCategory).stream().filter(r -> !this.recipeWrappers.contains(r)).forEach(arg_0 -> ((IRecipeRegistry)recipeRegistry).hideRecipe(arg_0));
        } else if (!AnvilRecipeHandler.getBlacklist().isEmpty()) {
            this.hideBlacklistedRecipes(recipeRegistry, (IRecipeCategory<IRecipeWrapper>)anvilRecipeCategory);
        }
    }

    private IVanillaRecipeFactory getRecipeFactory() {
        return this.registry.getJeiHelpers().getVanillaRecipeFactory();
    }

    private List<IRecipeWrapper> getRecipeWrappers(List<AnvilRecipe> recipes) {
        ArrayList wrapperList = Lists.newArrayList();
        for (AnvilRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            List<ItemStack> right = Arrays.asList(InputHelper.toStacks((IItemStack[])recipe.getRight().getItemArray()));
            ArrayList output = Lists.newArrayListWithCapacity((int)right.size());
            for (int i = 0; i < right.size(); ++i) {
                output.add(recipe.getOutputStack());
            }
            for (IItemStack left : recipe.getLeft().getItems()) {
                wrapperList.add(this.getRecipeFactory().createAnvilRecipe(InputHelper.toStack((IItemStack)left), right, (List)output));
            }
        }
        return wrapperList;
    }

    private void hideBlacklistedRecipes(IRecipeRegistry recipeRegistry, IRecipeCategory<IRecipeWrapper> anvilRecipeCategory) {
        recipeRegistry.getRecipeWrappers(anvilRecipeCategory).stream().collect(Collectors.toMap(r -> r, r -> {
            Ingredients ingredients = new Ingredients();
            r.getIngredients((IIngredients)ingredients);
            return ingredients;
        })).forEach((wrapper, ingredients) -> {
            List inputs = ingredients.getInputs(ItemStack.class);
            ItemStack left = (ItemStack)((List)inputs.get(0)).get(0);
            List right = (List)inputs.get(1);
            List output = (List)ingredients.getOutputs(ItemStack.class).get(0);
            if (AnvilRecipeHandler.getBlacklist().stream().anyMatch(restriction -> restriction.isBlacklisted(left, right, output))) {
                LogHelper.logInfo((String)String.format("Hiding blacklisted recipe from JEI:%n\tRight: %s%n\tLeft: %s%n\tOutput: %s", LogHelper.getStackDescription((Object)left), LogHelper.getStackDescription((Object)right), LogHelper.getStackDescription((Object)output)));
                recipeRegistry.hideRecipe(wrapper);
            }
        });
    }
}

