/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.api;

import com.legacy.aether.api.NamespacedWrapper;
import com.legacy.aether.api.accessories.AetherAccessory;
import com.legacy.aether.api.enchantments.AetherEnchantment;
import com.legacy.aether.api.enchantments.AetherEnchantmentFuel;
import com.legacy.aether.api.freezables.AetherFreezable;
import com.legacy.aether.api.freezables.AetherFreezableFuel;
import com.legacy.aether.api.moa.AetherMoaType;
import com.legacy.aether.api.player.IPlayerAether;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="aether_legacy")
public class AetherAPI {
    private static IForgeRegistry<AetherAccessory> iAccessoryRegistry;
    private static IForgeRegistry<AetherEnchantment> iEnchantmentRegistry;
    private static IForgeRegistry<AetherEnchantmentFuel> iEnchantmentFuelRegistry;
    private static IForgeRegistry<AetherFreezable> iFreezableRegistry;
    private static IForgeRegistry<AetherFreezableFuel> iFreezableFuelRegistry;
    private static IForgeRegistry<AetherMoaType> iMoaTypeRegistry;
    private static final int MAX_REGISTRY_ID = 32766;
    @CapabilityInject(value=IPlayerAether.class)
    public static Capability<IPlayerAether> AETHER_PLAYER;
    private static final AetherAPI instance;

    @SubscribeEvent
    public static void onMakeRegistries(RegistryEvent.NewRegistry event) {
        iAccessoryRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:accessories"), AetherAccessory.class, 0, 32766).create();
        iEnchantmentRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:enchantments"), AetherEnchantment.class, 0, 32766).create();
        iEnchantmentFuelRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:enchantment_fuels"), AetherEnchantmentFuel.class, 0, 32766).create();
        iFreezableRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:freezables"), AetherFreezable.class, 0, 32766).create();
        iFreezableFuelRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:freezable_fuels"), AetherFreezableFuel.class, 0, 32766).create();
        iMoaTypeRegistry = AetherAPI.makeRegistry(new ResourceLocation("aetherAPI:moa_types"), AetherMoaType.class, 0, 32766).create();
    }

    public IPlayerAether get(EntityPlayer player) {
        return (IPlayerAether)player.getCapability(AETHER_PLAYER, null);
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type, int min, int max) {
        return new RegistryBuilder().setName(name).setType(type).setIDRange(min, max).addCallback(new NamespacedWrapper.Factory());
    }

    public boolean isAccessory(ItemStack stack) {
        return iAccessoryRegistry.containsKey(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public AetherAccessory getAccessory(ItemStack stack) {
        return (AetherAccessory)iAccessoryRegistry.getValue(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public boolean hasEnchantment(ItemStack stack) {
        return iEnchantmentRegistry.containsKey(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public AetherEnchantment getEnchantment(ItemStack stack) {
        return (AetherEnchantment)iEnchantmentRegistry.getValue(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public boolean isEnchantmentFuel(ItemStack stack) {
        return iEnchantmentFuelRegistry.containsKey(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public AetherEnchantmentFuel getEnchantmentFuel(ItemStack stack) {
        return (AetherEnchantmentFuel)iEnchantmentFuelRegistry.getValue(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public boolean hasFreezable(ItemStack stack) {
        return iFreezableRegistry.containsKey(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public AetherFreezable getFreezable(ItemStack stack) {
        return (AetherFreezable)iFreezableRegistry.getValue(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public boolean isFreezableFuel(ItemStack stack) {
        return iFreezableFuelRegistry.containsKey(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public AetherFreezableFuel getFreezableFuel(ItemStack stack) {
        return (AetherFreezableFuel)iFreezableFuelRegistry.getValue(new ResourceLocation(stack.func_77973_b().getRegistryName().toString() + "_meta_" + (stack.func_77984_f() ? 0 : stack.func_77960_j())));
    }

    public List<AetherEnchantment> getEnchantmentValues() {
        return iEnchantmentRegistry.getValues();
    }

    public List<AetherFreezable> getFreezableValues() {
        return iFreezableRegistry.getValues();
    }

    public int getMoaTypeId(AetherMoaType type) {
        return iMoaTypeRegistry.getValues().indexOf(type);
    }

    public AetherMoaType getMoaType(int id) {
        return (AetherMoaType)iMoaTypeRegistry.getValues().get(id);
    }

    public AetherMoaType getRandomMoaType() {
        return (AetherMoaType)iMoaTypeRegistry.getValues().get(new Random().nextInt(this.getMoaTypeSize()));
    }

    public Collection<AetherMoaType> getMoaTypes() {
        return iMoaTypeRegistry.getValues();
    }

    public AetherMoaType getMoaType(ResourceLocation key) {
        return (AetherMoaType)iMoaTypeRegistry.getValue(key);
    }

    public int getMoaTypeSize() {
        return iMoaTypeRegistry.getEntries().size();
    }

    public static AetherAPI getInstance() {
        return instance;
    }

    static {
        AETHER_PLAYER = null;
        instance = new AetherAPI();
    }
}

