/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="aether_legacy")
@Config.LangKey(value="aether_legacy.config.title")
public class AetherConfig {
    public static final Dimension dimension = new Dimension();
    public static final WorldGenOptions world_gen = new WorldGenOptions();
    public static final VisualOptions visual_options = new VisualOptions();
    public static final GameplayChanges gameplay_changes = new GameplayChanges();

    @Mod.EventBusSubscriber(modid="aether_legacy")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("aether_legacy")) {
                ConfigManager.sync((String)"aether_legacy", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class GameplayChanges {
        @Config.Comment(value={"The max amount of life shards that can be used per player"})
        public int max_life_shards = 10;
        @Config.Comment(value={"If enabled, Aether Portals can only be lit by Skyroot Buckets"})
        public boolean skyroot_bucket_only = false;
        @Config.Comment(value={"Makes it so you have to eat Ambrosium, instead of just right clicking to heal"})
        public boolean ambro_is_edible = false;
        @Config.Comment(value={"Swaps the Golden Feather with the Valkyrie Cape in dungeon loot"})
        public boolean valkyrie_cape = false;
        @Config.Comment(value={"Disables spawn of Aether Legacy portal for use with portal being provided by another mod."})
        public boolean disable_portal = false;
        @Config.Comment(value={"Disables startup loot when entering the Aether"})
        public boolean disable_startup_loot = false;
    }

    public static class VisualOptions {
        @Config.Comment(value={"Changes Aether mobs to use their old models, if applicable"})
        public boolean legacy_models = false;
        @Config.Comment(value={"Aerclouds will use their more saturated colors from later updates"})
        public boolean updated_aercloud_colors = false;
        @Config.Comment(value={"Disables the random trivia/tips you see during loading screens"})
        @Config.RequiresMcRestart
        public boolean trivia_disabled = false;
    }

    public static class WorldGenOptions {
        @Config.Comment(value={"Enables natural christmas decor"})
        public boolean christmas_time = false;
        @Config.Comment(value={"Enables naturally generating tallgrass"})
        public boolean tallgrass_enabled = false;
        @Config.Comment(value={"Enables natural Pink Aercloud generation"})
        public boolean pink_aerclouds = false;
    }

    public static class Dimension {
        @Config.RangeInt(min=2, max=256)
        @Config.RequiresMcRestart
        @Config.Comment(value={"Set the Dimension ID for the Aether."})
        public int aether_dimension_id = 4;
    }
}

