/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether;

import com.legacy.aether.AetherEventHandler;
import com.legacy.aether.CommonProxy;
import com.legacy.aether.advancements.AetherAdvancements;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.IPlayerAetherStorage;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.entities.AetherEntities;
import com.legacy.aether.events.AetherEntityEvents;
import com.legacy.aether.networking.AetherNetworkingManager;
import com.legacy.aether.player.capability.PlayerAetherManager;
import com.legacy.aether.registry.AetherRegistryEvent;
import com.legacy.aether.registry.sounds.SoundsAether;
import com.legacy.aether.tile_entities.AetherTileEntities;
import com.legacy.aether.universal.crafttweaker.AetherCraftTweakerPlugin;
import com.legacy.aether.world.AetherWorld;
import com.legacy.aether.world.storage.loot.conditions.LootConditionsAether;
import com.legacy.aether.world.storage.loot.functions.LootFunctionsAether;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(name="Aether Legacy", modid="aether_legacy", version="1.4.4", acceptedMinecraftVersions="1.12.2", updateJSON="https://raw.githubusercontent.com/Modding-Legacy/Aether-Legacy/master/aether-legacy-changelog.json")
public class Aether {
    public static final String modid = "aether_legacy";
    public static final String version = "1.4.4";
    @Mod.Instance(value="aether_legacy")
    public static Aether instance;
    @SidedProxy(modId="aether_legacy", clientSide="com.legacy.aether.client.ClientProxy", serverSide="com.legacy.aether.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInitialization(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IPlayerAether.class, (Capability.IStorage)new IPlayerAetherStorage(), () -> null);
        BlocksAether.initialization();
        SoundsAether.initialization();
        LootConditionsAether.initialization();
        LootFunctionsAether.initialization();
        AetherAdvancements.initialization();
        AetherNetworkingManager.preInitialization();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            AetherCraftTweakerPlugin.preInitialization();
        }
        CommonProxy.registerEvent(new AetherRegistryEvent());
        proxy.preInitialization();
    }

    @Mod.EventHandler
    public void initialization(FMLInitializationEvent event) {
        PlayerAetherManager.initialization();
        AetherEntities.initialization();
        AetherTileEntities.initialization();
        AetherWorld.initialization();
        CommonProxy.registerEvent(new AetherEventHandler());
        CommonProxy.registerEvent(new AetherEntityEvents());
        proxy.initialization();
    }

    @Mod.EventHandler
    public void postInitialization(FMLPostInitializationEvent event) {
        proxy.postInitialization();
        FurnaceRecipes.func_77602_a().func_151393_a(BlocksAether.aether_log, new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
    }

    public static ResourceLocation locate(String location) {
        return new ResourceLocation(modid, location);
    }

    public static String modAddress() {
        return "aether_legacy:";
    }

    public static String doubleDropNotifier() {
        return "aether_legacy_double_drops";
    }
}

