/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.qualitytools.config.QualityEntry;
import com.tmtravlr.qualitytools.config.QualityItem;
import java.lang.reflect.Type;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.JsonUtils;

public class QualityType {
    public static final Random RAND = new Random();
    public String[] slots;
    public QualityEntry[] qualities;
    public QualityItem[] blacklist;
    public QualityItem[] whitelist;

    public boolean itemMatches(ItemStack stack) {
        boolean matches = false;
        for (QualityItem qualityItem : this.whitelist) {
            if (qualityItem == null || !qualityItem.itemMatches(stack)) continue;
            matches = true;
        }
        for (QualityItem qualityItem : this.blacklist) {
            if (qualityItem == null || !qualityItem.itemMatches(stack)) continue;
            matches = false;
        }
        return matches;
    }

    public void generateQualityTag(ItemStack stack, boolean skipNormal) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("Quality")) {
            stack.func_77978_p().func_82580_o("Quality");
        }
        NBTTagCompound tag = new NBTTagCompound();
        QualityEntry entry = this.chooseQualityEntry(skipNormal);
        if (!entry.name.equalsIgnoreCase("normal")) {
            tag.func_74778_a("Name", entry.name);
            tag.func_74778_a("Color", entry.color.func_96297_d());
            NBTTagList slotList = new NBTTagList();
            for (String slot : this.slots) {
                slotList.func_74742_a((NBTBase)new NBTTagString(slot));
            }
            tag.func_74782_a("Slots", (NBTBase)slotList);
            NBTTagList modifierList = new NBTTagList();
            for (String attributeName : entry.attributeMap.keySet()) {
                for (AttributeModifier modifier : entry.attributeMap.get((Object)attributeName)) {
                    NBTTagCompound modifierTag = SharedMonsterAttributes.func_111262_a((AttributeModifier)new AttributeModifier(UUID.randomUUID(), modifier.func_111166_b(), modifier.func_111164_d(), modifier.func_111169_c()));
                    modifierTag.func_74778_a("AttributeName", attributeName);
                    modifierList.func_74742_a((NBTBase)modifierTag);
                }
            }
            tag.func_74782_a("AttributeModifiers", (NBTBase)modifierList);
        }
        stack.func_77978_p().func_74782_a("Quality", (NBTBase)tag);
    }

    public QualityEntry chooseQualityEntry(boolean skipNormal) {
        int weightTotal = 0;
        for (QualityEntry entry : this.qualities) {
            if (skipNormal && entry.name.equalsIgnoreCase("normal")) continue;
            weightTotal += entry.weight;
        }
        if (weightTotal == 0) {
            return null;
        }
        int chosenWeight = RAND.nextInt(weightTotal) + 1;
        weightTotal = 0;
        for (QualityEntry entry : this.qualities) {
            if (skipNormal && entry.name.equalsIgnoreCase("normal") || chosenWeight > (weightTotal += entry.weight)) continue;
            return entry;
        }
        return null;
    }

    public static class Serializer
    implements JsonDeserializer<QualityType> {
        public QualityType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            QualityType quality = new QualityType();
            if (JsonUtils.func_151205_a((JsonObject)json, (String)"slot")) {
                quality.slots = new String[]{JsonUtils.func_151200_h((JsonObject)json, (String)"slot")};
            } else {
                JsonArray slotArray = JsonUtils.func_151214_t((JsonObject)json, (String)"slot");
                quality.slots = new String[slotArray.size()];
                for (int i = 0; i < quality.slots.length; ++i) {
                    if (!slotArray.get(i).isJsonPrimitive() || !slotArray.get(i).getAsJsonPrimitive().isString()) {
                        throw new JsonSyntaxException("Expected slot entry to be a string, was " + JsonUtils.func_151222_d((JsonElement)slotArray.get(i)));
                    }
                    quality.slots[i] = slotArray.get(i).getAsString();
                }
            }
            quality.qualities = (QualityEntry[])JsonUtils.func_188174_a((JsonObject)json, (String)"qualities", (JsonDeserializationContext)context, QualityEntry[].class);
            quality.blacklist = (QualityItem[])JsonUtils.func_188177_a((JsonObject)json, (String)"blacklist", (Object)new QualityItem[0], (JsonDeserializationContext)context, QualityItem[].class);
            quality.whitelist = (QualityItem[])JsonUtils.func_188177_a((JsonObject)json, (String)"whitelist", (Object)new QualityItem[0], (JsonDeserializationContext)context, QualityItem[].class);
            return quality;
        }
    }
}

