/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.mobstages;

import crafttweaker.CraftTweakerAPI;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.util.EntityUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.mobstages.MobStageInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod(modid="mobstages", name="Mob Stages", version="2.0.13", dependencies="required-after:bookshelf;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class MobStages {
    public static final LoggingHelper LOG = new LoggingHelper("Mob Stages");
    public static final Map<String, MobStageInfo> GLOBAL_STAGE_INFO = new HashMap<String, MobStageInfo>();
    public static final Map<String, Map<Integer, MobStageInfo>> DIMENSIONAL_STAGE_INFO = new HashMap<String, Map<Integer, MobStageInfo>>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        for (Map.Entry<String, MobStageInfo> entry : GLOBAL_STAGE_INFO.entrySet()) {
            if (ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(entry.getValue().getEntityId()))) continue;
            CraftTweakerAPI.logError((String)("No entity found for " + entry.getValue().getEntityId()));
        }
        for (String stage : DIMENSIONAL_STAGE_INFO.keySet()) {
            for (Map.Entry<Integer, MobStageInfo> entry : DIMENSIONAL_STAGE_INFO.get(stage).entrySet()) {
                if (ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(entry.getValue().getEntityId()))) continue;
                CraftTweakerAPI.logError((String)("No entity found for " + entry.getValue().getEntityId()));
            }
        }
    }

    public static MobStageInfo getOrCreateStageInfo(String stage, String entity) {
        MobStageInfo info = GLOBAL_STAGE_INFO.getOrDefault(entity, new MobStageInfo(stage, entity));
        GLOBAL_STAGE_INFO.put(entity, info);
        return info;
    }

    public static MobStageInfo getOrCreateStageInfo(String stage, String entity, int dimension) {
        Map map = DIMENSIONAL_STAGE_INFO.getOrDefault(entity, new HashMap());
        MobStageInfo info = map.getOrDefault(dimension, new MobStageInfo(stage, entity, dimension));
        map.put(dimension, info);
        DIMENSIONAL_STAGE_INFO.put(entity, map);
        return info;
    }

    public static boolean hasGlobalStage(String entityId) {
        return GLOBAL_STAGE_INFO.get(entityId) != null;
    }

    public static boolean hasDimensionStage(String entityId, int dimension) {
        return DIMENSIONAL_STAGE_INFO.containsKey(entityId) && DIMENSIONAL_STAGE_INFO.get(entityId).get(dimension) != null;
    }

    @SubscribeEvent
    public void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        ResourceLocation id = EntityList.func_191301_a((Entity)event.getEntity());
        if (id != null) {
            String name = id.toString();
            int dimension = event.getEntity().field_71093_bK;
            MobStageInfo info = null;
            if (MobStages.hasDimensionStage(name, dimension) && !MobStages.allowSpawning(info = DIMENSIONAL_STAGE_INFO.get(name).get(dimension), event)) {
                return;
            }
            if (MobStages.hasGlobalStage(name) && !MobStages.allowSpawning(info = GLOBAL_STAGE_INFO.get(name), event)) {
                return;
            }
        }
    }

    private static boolean allowSpawning(MobStageInfo info, LivingSpawnEvent.CheckSpawn event) {
        if (info != null) {
            if (info.allowSpawners() && event.isSpawner()) {
                return true;
            }
            for (EntityPlayer player : event.getWorld().field_73010_i) {
                if (!GameStageHelper.hasStage((EntityPlayer)player, (String)info.getStage()) || !(EntityUtils.getDistanceFromEntity((Entity)player, (Entity)event.getEntity()) < (double)info.getRange())) continue;
                return true;
            }
            if (info.getReplacement() != null && !info.getReplacement().isEmpty()) {
                try {
                    Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(info.getReplacement()), (World)event.getWorld());
                    entity.func_70107_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                    event.getWorld().func_72838_d(entity);
                    event.getEntity().func_70106_y();
                }
                catch (Exception e) {
                    LOG.trace("Failed to spawn replacement mob!", new Object[]{e});
                }
            }
        }
        event.setResult(Event.Result.DENY);
        return false;
    }
}

