/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.ITileTextbox;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTileTextbox
implements IMessage,
IMessageHandler<PacketTileTextbox, IMessage> {
    private BlockPos pos;
    private String text;
    private int index;

    public PacketTileTextbox() {
    }

    public PacketTileTextbox(String pword, BlockPos p) {
        this.pos = p;
        this.text = pword;
        this.index = 0;
    }

    public PacketTileTextbox(String pword, BlockPos p, int i) {
        this(pword, p);
        this.index = i;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.index = tags.func_74762_e("index");
        this.pos = new BlockPos(x, y, z);
        this.text = tags.func_74779_i("txt");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("index", this.index);
        tags.func_74778_a("txt", this.text);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketTileTextbox message, MessageContext ctx) {
        PacketTileTextbox.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private static void checkThreadAndEnqueue(final PacketTileTextbox message, final MessageContext ctx) {
        IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
        thread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.func_130014_f_();
                TileEntity tile = world.func_175625_s(message.pos);
                if (tile != null && tile instanceof ITileTextbox) {
                    ((ITileTextbox)tile).setText(message.index, message.text);
                    tile.func_70296_d();
                }
            }
        });
    }
}

