/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tiletransporter;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.item.tiletransporter.PacketChestSack;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilString;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemChestSackEmpty
extends BaseItem
implements IHasRecipe,
IHasConfig {
    public static final String name = "chest_sack_empty";
    private static List<String> blacklistAll;
    private Item fullSack;

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (pos == null) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        if (state == null || tile == null || state.func_177230_c() == null || state.func_177230_c().getRegistryName() == null) {
            UtilChat.sendStatusMessage(player, "chest_sack.error.null");
            return EnumActionResult.FAIL;
        }
        ResourceLocation blockId = state.func_177230_c().getRegistryName();
        if (UtilString.isInList(blacklistAll, blockId)) {
            UtilChat.sendStatusMessage(player, "chest_sack.error.blacklist");
            return EnumActionResult.FAIL;
        }
        UtilSound.playSound(player, pos, SoundRegistry.chest_sack_capture);
        if (world.field_72995_K) {
            ModCyclic.network.sendToServer((IMessage)new PacketChestSack(pos));
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " s ", "lbl", "lll", Character.valueOf('l'), "leather", Character.valueOf('b'), "slimeball", Character.valueOf('s'), "string");
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " s ", "lbl", "lll", Character.valueOf('l'), "leather", Character.valueOf('b'), new ItemStack(Items.field_151034_e), Character.valueOf('s'), "string");
    }

    public void setFullSack(Item item) {
        this.fullSack = item;
    }

    public Item getFullSack() {
        return this.fullSack;
    }

    public static void gatherTileEntity(BlockPos position, EntityPlayer player, World world, TileEntity tile) {
        Item chest_sack;
        if (tile == null) {
            return;
        }
        IBlockState state = world.func_180495_p(position);
        NBTTagCompound tileData = new NBTTagCompound();
        tile.func_189515_b(tileData);
        NBTTagCompound itemData = new NBTTagCompound();
        itemData.func_74778_a("blockname", state.func_177230_c().func_149739_a());
        itemData.func_74782_a("tile", (NBTBase)tileData);
        itemData.func_74768_a("block", Block.func_149682_b((Block)state.func_177230_c()));
        itemData.func_74768_a("blockstate", state.func_177230_c().func_176201_c(state));
        EnumHand hand = EnumHand.MAIN_HAND;
        ItemStack held = player.func_184586_b(hand);
        if (held == null || !(held.func_77973_b() instanceof ItemChestSackEmpty)) {
            hand = EnumHand.OFF_HAND;
            held = player.func_184586_b(hand);
        }
        if (held != null && held.func_190916_E() > 0 && held.func_77973_b() instanceof ItemChestSackEmpty && (chest_sack = ((ItemChestSackEmpty)held.func_77973_b()).getFullSack()) != null) {
            if (!UtilPlaceBlocks.destroyBlock(world, position)) {
                UtilChat.sendStatusMessage(player, "chest_sack.error.pickup");
                world.func_175656_a(position, state);
                return;
            }
            ItemStack drop = new ItemStack(chest_sack);
            drop.func_77982_d(itemData);
            UtilItemStack.dropItemStackInWorld(world, player.func_180425_c(), drop);
            if (!player.field_71075_bZ.field_75098_d && held.func_190916_E() > 0) {
                held.func_190918_g(1);
                if (held.func_190916_E() == 0) {
                    held = ItemStack.field_190927_a;
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "modpacks";
        String[] deflist = new String[]{"extracells:fluidcrafter", "extracells:ecbaseblock", "extracells:fluidfiller", "refinedstorage:disk_manipulator", "refinedstorage:disk_drive", "refinedstorage:crafter", "refinedstorage:crafter_manager", "refinedstorage:grid", "parabox:parabox", "immersivengineering:metal_device1"};
        Object[] blacklist = config.getStringList("SackHoldingBlacklist", category, deflist, "Containers that cannot be lifted up with the Empty Sack of Holding.  Use block id; for example minecraft:chest");
        blacklistAll = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
    }
}

